/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.bson.BsonDocumentWrapper;
import me.lucko.helper.mongo.external.bson.BsonJavaScript;
import me.lucko.helper.mongo.external.mongodriver.BasicDBObject;
import me.lucko.helper.mongo.external.mongodriver.DBCollection;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.DBObjectCodec;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.operation.GroupOperation;

public class GroupCommand {
    private final String collectionName;
    private final DBObject keys;
    private final String keyf;
    private final DBObject condition;
    private final DBObject initial;
    private final String reduce;
    private final String finalize;
    private final Collation collation;

    public GroupCommand(DBCollection collection, DBObject keys, DBObject condition, DBObject initial, String reduce, String finalize) {
        this(collection, keys, condition, initial, reduce, finalize, null);
    }

    public GroupCommand(DBCollection collection, DBObject keys, DBObject condition, DBObject initial, String reduce, String finalize, Collation collation) {
        Assertions.notNull("collection", collection);
        this.collectionName = collection.getName();
        this.keys = keys;
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
        this.keyf = null;
        this.collation = collation;
    }

    public GroupCommand(DBCollection collection, String keyf, DBObject condition, DBObject initial, String reduce, String finalize) {
        this(collection, keyf, condition, initial, reduce, finalize, null);
    }

    public GroupCommand(DBCollection collection, String keyf, DBObject condition, DBObject initial, String reduce, String finalize, Collation collation) {
        Assertions.notNull("collection", collection);
        this.collectionName = collection.getName();
        this.keyf = Assertions.notNull("keyf", keyf);
        this.condition = condition;
        this.initial = initial;
        this.reduce = reduce;
        this.finalize = finalize;
        this.keys = null;
        this.collation = collation;
    }

    public DBObject toDBObject() {
        BasicDBObject args = new BasicDBObject("ns", this.collectionName).append("cond", this.condition).append("$reduce", this.reduce).append("initial", this.initial);
        if (this.keys != null) {
            args.put("key", this.keys);
        }
        if (this.keyf != null) {
            args.put("$keyf", this.keyf);
        }
        if (this.finalize != null) {
            args.put("finalize", this.finalize);
        }
        return new BasicDBObject("group", args);
    }

    GroupOperation<DBObject> toOperation(MongoNamespace namespace, DBObjectCodec codec) {
        if (this.initial == null) {
            throw new IllegalArgumentException("Group command requires an initial document for the aggregate result");
        }
        if (this.reduce == null) {
            throw new IllegalArgumentException("Group command requires a reduce function for the aggregate result");
        }
        GroupOperation<DBObject> operation = new GroupOperation<DBObject>(namespace, new BsonJavaScript(this.reduce), new BsonDocumentWrapper<DBObject>(this.initial, codec), codec);
        if (this.keys != null) {
            operation.key(new BsonDocumentWrapper<DBObject>(this.keys, codec));
        }
        if (this.keyf != null) {
            operation.keyFunction(new BsonJavaScript(this.keyf));
        }
        if (this.condition != null) {
            operation.filter(new BsonDocumentWrapper<DBObject>(this.condition, codec));
        }
        if (this.finalize != null) {
            operation.finalizeFunction(new BsonJavaScript(this.finalize));
        }
        operation.collation(this.collation);
        return operation;
    }
}

