/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.bson.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.binding.ConnectionSource;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadWriteBinding;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;
import me.lucko.helper.mongo.external.mongodriver.internal.session.ClientSessionContext;
import me.lucko.helper.mongo.external.mongodriver.session.ClientSession;
import me.lucko.helper.mongo.external.mongodriver.session.SessionContext;

class ClientSessionBinding
implements ReadWriteBinding {
    private final ReadWriteBinding wrapped;
    private final ClientSession session;
    private final boolean ownsSession;
    private final ClientSessionContext sessionContext;

    ClientSessionBinding(ClientSession session, boolean ownsSession, ReadWriteBinding wrapped) {
        this.wrapped = Assertions.notNull("wrapped", wrapped);
        this.ownsSession = ownsSession;
        this.session = Assertions.notNull("session", session);
        this.sessionContext = new ClientSessionContext(session);
    }

    @Override
    public ReadPreference getReadPreference() {
        return this.wrapped.getReadPreference();
    }

    @Override
    public int getCount() {
        return this.wrapped.getCount();
    }

    @Override
    public ReadWriteBinding retain() {
        this.wrapped.retain();
        return this;
    }

    @Override
    public void release() {
        this.wrapped.release();
        this.closeSessionIfCountIsZero();
    }

    private void closeSessionIfCountIsZero() {
        if (this.getCount() == 0 && this.ownsSession) {
            this.session.close();
        }
    }

    @Override
    public ConnectionSource getReadConnectionSource() {
        return new SessionBindingConnectionSource(this.wrapped.getReadConnectionSource());
    }

    @Override
    public SessionContext getSessionContext() {
        return this.sessionContext;
    }

    @Override
    public ConnectionSource getWriteConnectionSource() {
        return new SessionBindingConnectionSource(this.wrapped.getWriteConnectionSource());
    }

    private class SessionBindingConnectionSource
    implements ConnectionSource {
        private ConnectionSource wrapped;

        SessionBindingConnectionSource(ConnectionSource wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public ServerDescription getServerDescription() {
            return this.wrapped.getServerDescription();
        }

        @Override
        public SessionContext getSessionContext() {
            return ClientSessionBinding.this.sessionContext;
        }

        @Override
        public Connection getConnection() {
            return this.wrapped.getConnection();
        }

        @Override
        public ConnectionSource retain() {
            this.wrapped = this.wrapped.retain();
            return this;
        }

        @Override
        public int getCount() {
            return this.wrapped.getCount();
        }

        @Override
        public void release() {
            this.wrapped.release();
            ClientSessionBinding.this.closeSessionIfCountIsZero();
        }
    }
}

