/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonDocumentReader;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.mongodriver.AcknowledgedBulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.BulkWriteError;
import me.lucko.helper.mongo.external.mongodriver.BulkWriteException;
import me.lucko.helper.mongo.external.mongodriver.BulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.mongodriver.DBObjects;
import me.lucko.helper.mongo.external.mongodriver.MongoBulkWriteException;
import me.lucko.helper.mongo.external.mongodriver.UnacknowledgedBulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteUpsert;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteConcernError;

final class BulkWriteHelper {
    static BulkWriteResult translateBulkWriteResult(me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteResult bulkWriteResult, Decoder<DBObject> decoder) {
        if (bulkWriteResult.wasAcknowledged()) {
            Integer modifiedCount = bulkWriteResult.isModifiedCountAvailable() ? Integer.valueOf(bulkWriteResult.getModifiedCount()) : null;
            return new AcknowledgedBulkWriteResult(bulkWriteResult.getInsertedCount(), bulkWriteResult.getMatchedCount(), bulkWriteResult.getDeletedCount(), modifiedCount, BulkWriteHelper.translateBulkWriteUpserts(bulkWriteResult.getUpserts(), decoder));
        }
        return new UnacknowledgedBulkWriteResult();
    }

    static List<me.lucko.helper.mongo.external.mongodriver.BulkWriteUpsert> translateBulkWriteUpserts(List<BulkWriteUpsert> upserts, Decoder<DBObject> decoder) {
        ArrayList<me.lucko.helper.mongo.external.mongodriver.BulkWriteUpsert> retVal = new ArrayList<me.lucko.helper.mongo.external.mongodriver.BulkWriteUpsert>(upserts.size());
        for (BulkWriteUpsert cur : upserts) {
            retVal.add(new me.lucko.helper.mongo.external.mongodriver.BulkWriteUpsert(cur.getIndex(), BulkWriteHelper.getUpsertedId(cur, decoder)));
        }
        return retVal;
    }

    private static Object getUpsertedId(BulkWriteUpsert cur, Decoder<DBObject> decoder) {
        return decoder.decode(new BsonDocumentReader(new BsonDocument("_id", cur.getId())), DecoderContext.builder().build()).get("_id");
    }

    static BulkWriteException translateBulkWriteException(MongoBulkWriteException e, Decoder<DBObject> decoder) {
        return new BulkWriteException(BulkWriteHelper.translateBulkWriteResult(e.getWriteResult(), decoder), BulkWriteHelper.translateWriteErrors(e.getWriteErrors()), BulkWriteHelper.translateWriteConcernError(e.getWriteConcernError()), e.getServerAddress());
    }

    static me.lucko.helper.mongo.external.mongodriver.WriteConcernError translateWriteConcernError(WriteConcernError writeConcernError) {
        return writeConcernError == null ? null : new me.lucko.helper.mongo.external.mongodriver.WriteConcernError(writeConcernError.getCode(), writeConcernError.getMessage(), DBObjects.toDBObject(writeConcernError.getDetails()));
    }

    static List<BulkWriteError> translateWriteErrors(List<me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteError> errors) {
        ArrayList<BulkWriteError> retVal = new ArrayList<BulkWriteError>(errors.size());
        for (me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteError cur : errors) {
            retVal.add(new BulkWriteError(cur.getCode(), cur.getMessage(), DBObjects.toDBObject(cur.getDetails()), cur.getIndex()));
        }
        return retVal;
    }

    private BulkWriteHelper() {
    }
}

