/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonTimestamp;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.types.BSONTimestamp;

public class BSONTimestampCodec
implements Codec<BSONTimestamp> {
    @Override
    public void encode(BsonWriter writer, BSONTimestamp value, EncoderContext encoderContext) {
        writer.writeTimestamp(new BsonTimestamp(value.getTime(), value.getInc()));
    }

    @Override
    public BSONTimestamp decode(BsonReader reader, DecoderContext decoderContext) {
        BsonTimestamp timestamp = reader.readTimestamp();
        return new BSONTimestamp(timestamp.getTime(), timestamp.getInc());
    }

    @Override
    public Class<BSONTimestamp> getEncoderClass() {
        return BSONTimestamp.class;
    }
}

