/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonValue;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.conversions.Bson;
import me.lucko.helper.mongo.external.mongodriver.MongoIterableImpl;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.OperationExecutor;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.AggregateIterable;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.operation.AggregateOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.AggregateToCollectionOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.BatchCursor;
import me.lucko.helper.mongo.external.mongodriver.operation.FindOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;
import me.lucko.helper.mongo.external.mongodriver.session.ClientSession;

class AggregateIterableImpl<TDocument, TResult>
extends MongoIterableImpl<TResult>
implements AggregateIterable<TResult> {
    private final MongoNamespace namespace;
    private final Class<TDocument> documentClass;
    private final Class<TResult> resultClass;
    private final WriteConcern writeConcern;
    private final CodecRegistry codecRegistry;
    private final List<? extends Bson> pipeline;
    private Boolean allowDiskUse;
    private long maxTimeMS;
    private long maxAwaitTimeMS;
    private Boolean useCursor;
    private Boolean bypassDocumentValidation;
    private Collation collation;
    private String comment;
    private Bson hint;

    AggregateIterableImpl(ClientSession clientSession, MongoNamespace namespace, Class<TDocument> documentClass, Class<TResult> resultClass, CodecRegistry codecRegistry, ReadPreference readPreference, ReadConcern readConcern, WriteConcern writeConcern, OperationExecutor executor, List<? extends Bson> pipeline) {
        super(clientSession, executor, readConcern, readPreference);
        this.namespace = Assertions.notNull("namespace", namespace);
        this.documentClass = Assertions.notNull("documentClass", documentClass);
        this.resultClass = Assertions.notNull("resultClass", resultClass);
        this.codecRegistry = Assertions.notNull("codecRegistry", codecRegistry);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.pipeline = Assertions.notNull("pipeline", pipeline);
    }

    @Override
    public void toCollection() {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        if (this.getOutCollection(aggregateList) == null) {
            throw new IllegalStateException("The last stage of the aggregation pipeline must be $out");
        }
        this.getExecutor().execute(this.createAggregateToCollectionOperation(aggregateList), this.getClientSession());
    }

    @Override
    public AggregateIterable<TResult> allowDiskUse(Boolean allowDiskUse) {
        this.allowDiskUse = allowDiskUse;
        return this;
    }

    @Override
    public AggregateIterable<TResult> batchSize(int batchSize) {
        super.batchSize(batchSize);
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    @Override
    @Deprecated
    public AggregateIterable<TResult> useCursor(Boolean useCursor) {
        this.useCursor = useCursor;
        return this;
    }

    @Override
    public AggregateIterable<TResult> maxAwaitTime(long maxAwaitTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxAwaitTimeMS = TimeUnit.MILLISECONDS.convert(maxAwaitTime, timeUnit);
        return this;
    }

    @Override
    public AggregateIterable<TResult> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public AggregateIterable<TResult> comment(String comment) {
        this.comment = comment;
        return this;
    }

    @Override
    public AggregateIterable<TResult> hint(Bson hint) {
        this.hint = hint;
        return this;
    }

    @Override
    ReadOperation<BatchCursor<TResult>> asReadOperation() {
        List<BsonDocument> aggregateList = this.createBsonDocumentList(this.pipeline);
        BsonValue outCollection = this.getOutCollection(aggregateList);
        if (outCollection != null) {
            this.getExecutor().execute(this.createAggregateToCollectionOperation(aggregateList), this.getClientSession());
            FindOperation<TResult> findOperation = new FindOperation<TResult>(new MongoNamespace(this.namespace.getDatabaseName(), outCollection.asString().getValue()), this.codecRegistry.get(this.resultClass)).readConcern(this.getReadConcern()).collation(this.collation);
            if (this.getBatchSize() != null) {
                findOperation.batchSize(this.getBatchSize());
            }
            return findOperation;
        }
        return new AggregateOperation<TResult>(this.namespace, aggregateList, this.codecRegistry.get(this.resultClass)).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).maxAwaitTime(this.maxAwaitTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).batchSize(this.getBatchSize()).useCursor(this.useCursor).readConcern(this.getReadConcern()).collation(this.collation).hint(this.hint == null ? null : this.hint.toBsonDocument(this.documentClass, this.codecRegistry)).comment(this.comment);
    }

    private BsonValue getOutCollection(List<BsonDocument> aggregateList) {
        return aggregateList.size() == 0 ? null : aggregateList.get(aggregateList.size() - 1).get("$out");
    }

    private AggregateToCollectionOperation createAggregateToCollectionOperation(List<BsonDocument> aggregateList) {
        return new AggregateToCollectionOperation(this.namespace, aggregateList, this.writeConcern).maxTime(this.maxTimeMS, TimeUnit.MILLISECONDS).allowDiskUse(this.allowDiskUse).bypassDocumentValidation(this.bypassDocumentValidation).collation(this.collation).hint(this.hint == null ? null : this.hint.toBsonDocument(this.documentClass, this.codecRegistry)).comment(this.comment);
    }

    private List<BsonDocument> createBsonDocumentList(List<? extends Bson> pipeline) {
        ArrayList<BsonDocument> aggregateList = new ArrayList<BsonDocument>(pipeline.size());
        for (Bson bson : pipeline) {
            if (bson == null) {
                throw new IllegalArgumentException("pipeline can not contain a null value");
            }
            aggregateList.add(bson.toBsonDocument(this.documentClass, this.codecRegistry));
        }
        return aggregateList;
    }
}

