/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs.pojo;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.codecs.pojo.CollectionPropertyCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.pojo.EnumPropertyCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.pojo.FallbackPropertyCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.pojo.MapPropertyCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PojoCodec;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PropertyCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.pojo.PropertyCodecRegistry;
import me.lucko.helper.mongo.external.bson.codecs.pojo.TypeWithTypeParameters;

class PropertyCodecRegistryImpl
implements PropertyCodecRegistry {
    private final List<PropertyCodecProvider> propertyCodecProviders;

    PropertyCodecRegistryImpl(PojoCodec<?> pojoCodec, CodecRegistry codecRegistry, List<PropertyCodecProvider> propertyCodecProviders) {
        ArrayList<PropertyCodecProvider> augmentedProviders = new ArrayList<PropertyCodecProvider>();
        if (propertyCodecProviders != null) {
            augmentedProviders.addAll(propertyCodecProviders);
        }
        augmentedProviders.add(new CollectionPropertyCodecProvider());
        augmentedProviders.add(new MapPropertyCodecProvider());
        augmentedProviders.add(new EnumPropertyCodecProvider(codecRegistry));
        augmentedProviders.add(new FallbackPropertyCodecProvider(pojoCodec, codecRegistry));
        this.propertyCodecProviders = augmentedProviders;
    }

    public <S> Codec<S> get(TypeWithTypeParameters<S> type) {
        for (PropertyCodecProvider propertyCodecProvider : this.propertyCodecProviders) {
            Codec<S> codec = propertyCodecProvider.get(type, this);
            if (codec == null) continue;
            return codec;
        }
        return null;
    }
}

