/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson.codecs;

import me.lucko.helper.mongo.external.bson.BsonReader;
import me.lucko.helper.mongo.external.bson.BsonValue;
import me.lucko.helper.mongo.external.bson.BsonWriter;
import me.lucko.helper.mongo.external.bson.codecs.BsonValueCodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistries;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;

public class BsonValueCodec
implements Codec<BsonValue> {
    private final CodecRegistry codecRegistry;

    public BsonValueCodec() {
        this(CodecRegistries.fromProviders(new BsonValueCodecProvider()));
    }

    public BsonValueCodec(CodecRegistry codecRegistry) {
        this.codecRegistry = codecRegistry;
    }

    @Override
    public BsonValue decode(BsonReader reader, DecoderContext decoderContext) {
        return (BsonValue)this.codecRegistry.get(BsonValueCodecProvider.getClassForBsonType(reader.getCurrentBsonType())).decode(reader, decoderContext);
    }

    @Override
    public void encode(BsonWriter writer, BsonValue value, EncoderContext encoderContext) {
        Codec<?> codec = this.codecRegistry.get(value.getClass());
        encoderContext.encodeWithChildContext(codec, writer, value);
    }

    @Override
    public Class<BsonValue> getEncoderClass() {
        return BsonValue.class;
    }
}

