/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.bson;

import java.io.Serializable;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonDocumentWrapper;
import me.lucko.helper.mongo.external.bson.assertions.Assertions;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.codecs.DocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.Encoder;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.bson.conversions.Bson;
import me.lucko.helper.mongo.external.bson.json.JsonReader;
import me.lucko.helper.mongo.external.bson.json.JsonWriter;
import me.lucko.helper.mongo.external.bson.json.JsonWriterSettings;
import me.lucko.helper.mongo.external.bson.types.ObjectId;

public class Document
implements Map<String, Object>,
Serializable,
Bson {
    private static final long serialVersionUID = 6297731997167536582L;
    private final LinkedHashMap<String, Object> documentAsMap;

    public Document() {
        this.documentAsMap = new LinkedHashMap();
    }

    public Document(String key, Object value) {
        this.documentAsMap = new LinkedHashMap();
        this.documentAsMap.put(key, value);
    }

    public Document(Map<String, Object> map) {
        this.documentAsMap = new LinkedHashMap<String, Object>(map);
    }

    public static Document parse(String json) {
        return Document.parse(json, new DocumentCodec());
    }

    public static Document parse(String json, Decoder<Document> decoder) {
        Assertions.notNull("codec", decoder);
        JsonReader bsonReader = new JsonReader(json);
        return decoder.decode(bsonReader, DecoderContext.builder().build());
    }

    public <C> BsonDocument toBsonDocument(Class<C> documentClass, CodecRegistry codecRegistry) {
        return new BsonDocumentWrapper<Document>(this, codecRegistry.get(Document.class));
    }

    public Document append(String key, Object value) {
        this.documentAsMap.put(key, value);
        return this;
    }

    public <T> T get(Object key, Class<T> clazz) {
        Assertions.notNull("clazz", clazz);
        return clazz.cast(this.documentAsMap.get(key));
    }

    public <T> T get(Object key, T defaultValue) {
        Assertions.notNull("defaultValue", defaultValue);
        Class<?> clazz = Assertions.notNull("clazz", defaultValue.getClass());
        Object value = this.documentAsMap.get(key);
        return (T)(value == null ? defaultValue : clazz.cast(value));
    }

    public Integer getInteger(Object key) {
        return (Integer)this.get(key);
    }

    public int getInteger(Object key, int defaultValue) {
        return this.get(key, defaultValue);
    }

    public Long getLong(Object key) {
        return (Long)this.get(key);
    }

    public Double getDouble(Object key) {
        return (Double)this.get(key);
    }

    public String getString(Object key) {
        return (String)this.get(key);
    }

    public Boolean getBoolean(Object key) {
        return (Boolean)this.get(key);
    }

    public boolean getBoolean(Object key, boolean defaultValue) {
        return this.get(key, defaultValue);
    }

    public ObjectId getObjectId(Object key) {
        return (ObjectId)this.get(key);
    }

    public Date getDate(Object key) {
        return (Date)this.get(key);
    }

    public String toJson() {
        return this.toJson(new JsonWriterSettings());
    }

    public String toJson(JsonWriterSettings writerSettings) {
        return this.toJson(writerSettings, new DocumentCodec());
    }

    public String toJson(Encoder<Document> encoder) {
        return this.toJson(new JsonWriterSettings(), encoder);
    }

    public String toJson(JsonWriterSettings writerSettings, Encoder<Document> encoder) {
        JsonWriter writer = new JsonWriter(new StringWriter(), writerSettings);
        encoder.encode(writer, this, EncoderContext.builder().isEncodingCollectibleDocument(true).build());
        return writer.getWriter().toString();
    }

    @Override
    public int size() {
        return this.documentAsMap.size();
    }

    @Override
    public boolean isEmpty() {
        return this.documentAsMap.isEmpty();
    }

    @Override
    public boolean containsValue(Object value) {
        return this.documentAsMap.containsValue(value);
    }

    @Override
    public boolean containsKey(Object key) {
        return this.documentAsMap.containsKey(key);
    }

    @Override
    public Object get(Object key) {
        return this.documentAsMap.get(key);
    }

    @Override
    public Object put(String key, Object value) {
        return this.documentAsMap.put(key, value);
    }

    @Override
    public Object remove(Object key) {
        return this.documentAsMap.remove(key);
    }

    @Override
    public void putAll(Map<? extends String, ?> map) {
        this.documentAsMap.putAll(map);
    }

    @Override
    public void clear() {
        this.documentAsMap.clear();
    }

    @Override
    public Set<String> keySet() {
        return this.documentAsMap.keySet();
    }

    @Override
    public Collection<Object> values() {
        return this.documentAsMap.values();
    }

    @Override
    public Set<Map.Entry<String, Object>> entrySet() {
        return this.documentAsMap.entrySet();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Document document = (Document)o;
        return this.documentAsMap.equals(document.documentAsMap);
    }

    @Override
    public int hashCode() {
        return this.documentAsMap.hashCode();
    }

    public String toString() {
        return "Document{" + this.documentAsMap + '}';
    }
}

