/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.plugin;

import javax.annotation.Nonnull;
import me.lucko.helper.mongo.HelperMongo;
import me.lucko.helper.mongo.MongoDatabaseCredentials;
import me.lucko.helper.mongo.MongoProvider;
import me.lucko.helper.mongo.plugin.MongoWrapper;
import me.lucko.helper.plugin.ExtendedJavaPlugin;
import me.lucko.helper.terminable.TerminableConsumer;
import org.bukkit.configuration.ConfigurationSection;

public class MongoPlugin
extends ExtendedJavaPlugin
implements MongoProvider {
    private MongoDatabaseCredentials globalCredentials;
    private HelperMongo globalDataSource;

    protected void enable() {
        this.globalCredentials = MongoDatabaseCredentials.fromConfig((ConfigurationSection)this.loadConfig("config.yml"));
        this.globalDataSource = this.getDataSource(this.globalCredentials);
        this.globalDataSource.bindWith((TerminableConsumer)this);
        this.provideService(MongoProvider.class, this);
        this.provideService(MongoDatabaseCredentials.class, this.globalCredentials);
        this.provideService(HelperMongo.class, this.globalDataSource);
    }

    @Override
    @Nonnull
    public HelperMongo getDataSource() {
        return this.globalDataSource;
    }

    @Override
    @Nonnull
    public HelperMongo getDataSource(@Nonnull MongoDatabaseCredentials credentials) {
        return new MongoWrapper(credentials);
    }

    @Override
    @Nonnull
    public MongoDatabaseCredentials getGlobalCredentials() {
        return this.globalCredentials;
    }
}

