/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.utils;

public final class Assert {
    private Assert() {
    }

    public static void raiseError(String error) {
        throw new AssertionFailedException(error);
    }

    public static void parametersNotNull(String names, Object ... objects) {
        String msgPrefix = "At least one of the parameters";
        if (objects != null) {
            if (objects.length == 1) {
                msgPrefix = "Parameter";
            }
            for (Object object : objects) {
                if (object != null) continue;
                Assert.raiseError(String.format("%s '%s' is null.", msgPrefix, names));
            }
        }
    }

    public static void parameterNotNull(String name, Object reference) {
        if (reference == null) {
            Assert.raiseError(String.format("Parameter '%s' is not expected to be null.", name));
        }
    }

    public static void parameterNotEmpty(String name, Iterable obj) {
        if (!obj.iterator().hasNext()) {
            Assert.raiseError(String.format("Parameter '%s' from type '%s' is expected to NOT be empty", name, obj.getClass().getName()));
        }
    }

    public static void parameterNotEmpty(String name, String value) {
        if (value != null && value.length() == 0) {
            Assert.raiseError(String.format("Parameter '%s' is expected to NOT be empty.", name));
        }
    }

    public static class AssertionFailedException
    extends RuntimeException {
        private static final long serialVersionUID = 435272532743543854L;

        public AssertionFailedException(String message) {
            super(message);
        }

        public AssertionFailedException(String message, Throwable cause) {
            super(message, cause);
        }
    }
}

