/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query.validation;

import java.util.List;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.query.FilterOperator;
import me.lucko.helper.mongo.external.morphia.query.validation.CollectionTypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.OperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ValidationFailure;
import me.lucko.helper.mongo.external.morphia.query.validation.ValueClassValidator;

public final class SizeOperationValidator
extends OperationValidator {
    private static final SizeOperationValidator INSTANCE = new SizeOperationValidator();

    private SizeOperationValidator() {
    }

    public static SizeOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.SIZE;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (!ValueClassValidator.valueIsClassOrSubclassOf(value, Number.class)) {
            validationFailures.add(new ValidationFailure(String.format("For a $size operation, value '%s' should be an integer type.  Instead it was a: %s", value, value.getClass())));
        }
        if (!CollectionTypeValidator.typeIsIterableOrArrayOrMap(mappedField.getType())) {
            validationFailures.add(new ValidationFailure(String.format("For a $size operation, field '%s' should be a List or array.  Instead it was a: %s", mappedField, mappedField.getType())));
        }
    }
}

