/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query.validation;

import java.util.List;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.query.FilterOperator;
import me.lucko.helper.mongo.external.morphia.query.validation.CollectionTypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.OperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ValidationFailure;

public final class NotInOperationValidator
extends OperationValidator {
    private static final NotInOperationValidator INSTANCE = new NotInOperationValidator();

    private NotInOperationValidator() {
    }

    public static NotInOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.NOT_IN;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (value == null) {
            validationFailures.add(new ValidationFailure(String.format("For a $nin operation, value cannot be null.", new Object[0])));
        } else if (!CollectionTypeValidator.typeIsIterableOrArrayOrMap(value.getClass())) {
            validationFailures.add(new ValidationFailure(String.format("For a $nin operation, value '%s' should be a List or array. Instead it was a: %s", value, value.getClass())));
        }
    }
}

