/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query.validation;

import java.util.List;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.query.FilterOperator;
import me.lucko.helper.mongo.external.morphia.query.validation.CollectionTypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.OperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ValidationFailure;

public final class AllOperationValidator
extends OperationValidator {
    private static final AllOperationValidator INSTANCE = new AllOperationValidator();

    private AllOperationValidator() {
    }

    public static AllOperationValidator getInstance() {
        return INSTANCE;
    }

    @Override
    protected FilterOperator getOperator() {
        return FilterOperator.ALL;
    }

    @Override
    protected void validate(MappedField mappedField, Object value, List<ValidationFailure> validationFailures) {
        if (value == null) {
            validationFailures.add(new ValidationFailure(String.format("For an $all operation, value cannot be null.", new Object[0])));
        } else if (!CollectionTypeValidator.typeIsIterableOrArrayOrMap(value.getClass())) {
            validationFailures.add(new ValidationFailure(String.format("For an $all operation, value '%s' should be an array, an Iterable, or a Map.  Instead it was a: %s", value, value.getClass())));
        }
    }
}

