/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.morphia.annotations.Serialized;
import me.lucko.helper.mongo.external.morphia.logging.Logger;
import me.lucko.helper.mongo.external.morphia.logging.MorphiaLoggerFactory;
import me.lucko.helper.mongo.external.morphia.mapping.MappedClass;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.Mapper;
import me.lucko.helper.mongo.external.morphia.query.FilterOperator;
import me.lucko.helper.mongo.external.morphia.query.ValidationException;
import me.lucko.helper.mongo.external.morphia.query.validation.AllOperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.DefaultTypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.DoubleTypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.EntityAnnotatedValueValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.EntityTypeAndIdValueValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ExistsOperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.GeoWithinOperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.InOperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.IntegerTypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.KeyValueTypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ListValueValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.LongTypeValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ModOperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.NotInOperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.PatternValueValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.SizeOperationValidator;
import me.lucko.helper.mongo.external.morphia.query.validation.ValidationFailure;

final class QueryValidator {
    private static final Logger LOG = MorphiaLoggerFactory.get(QueryValidator.class);

    private QueryValidator() {
    }

    static MappedField validateQuery(Class clazz, Mapper mapper, StringBuilder origProp, FilterOperator op, Object val, boolean validateNames, boolean validateTypes) {
        MappedField mf = null;
        String prop = origProp.toString();
        boolean hasTranslations = false;
        if (!origProp.substring(0, 1).equals("$")) {
            String[] parts = prop.split("\\.");
            if (clazz == null) {
                return null;
            }
            MappedClass mc = mapper.getMappedClass(clazz);
            int i = 0;
            while (true) {
                String part;
                boolean fieldIsArrayOperator = (part = parts[i]).equals("$") || part.matches("[0-9]+");
                mf = mc.getMappedField(part);
                if (mf == null && !fieldIsArrayOperator) {
                    mf = mc.getMappedFieldByJavaField(part);
                    if (validateNames && mf == null) {
                        throw new ValidationException(String.format("The field '%s' could not be found in '%s' while validating - %s; if you wish to continue please disable validation.", part, mc.getClazz().getName(), prop));
                    }
                    hasTranslations = true;
                    if (mf != null) {
                        parts[i] = mf.getNameToStore();
                    }
                }
                ++i;
                if (mf != null && mf.isMap()) {
                    ++i;
                }
                if (i >= parts.length) break;
                if (fieldIsArrayOperator) continue;
                if (validateNames && !QueryValidator.canQueryPast(mf)) {
                    throw new ValidationException(String.format("Cannot use dot-notation past '%s' in '%s'; found while validating - %s", part, mc.getClazz().getName(), prop));
                }
                if (mf == null && (mc.isInterface() || !validateNames)) break;
                if (mf == null) {
                    throw new ValidationException(String.format("The field '%s' could not be found in '%s'", prop, mc.getClazz().getName()));
                }
                mc = mapper.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass());
            }
            if (hasTranslations) {
                origProp.setLength(0);
                origProp.append(parts[0]);
                for (i = 1; i < parts.length; ++i) {
                    origProp.append('.');
                    origProp.append(parts[i]);
                }
            }
            if (validateTypes && mf != null) {
                ArrayList<ValidationFailure> typeValidationFailures = new ArrayList<ValidationFailure>();
                boolean compatibleForType = QueryValidator.isCompatibleForOperator(mc, mf, mf.getType(), op, val, typeValidationFailures);
                ArrayList<ValidationFailure> subclassValidationFailures = new ArrayList<ValidationFailure>();
                boolean compatibleForSubclass = QueryValidator.isCompatibleForOperator(mc, mf, mf.getSubClass(), op, val, subclassValidationFailures);
                if ((mf.isSingleValue() && !compatibleForType || mf.isMultipleValues() && !compatibleForSubclass && !compatibleForType) && LOG.isWarningEnabled()) {
                    LOG.warning(String.format("The type(s) for the query/update may be inconsistent; using an instance of type '%s' for the field '%s.%s' which is declared as '%s'", val.getClass().getName(), mf.getDeclaringClass().getName(), mf.getJavaFieldName(), mf.getType().getName()));
                    typeValidationFailures.addAll(subclassValidationFailures);
                    LOG.warning("Validation warnings: \n" + typeValidationFailures);
                }
            }
        }
        return mf;
    }

    private static boolean canQueryPast(MappedField mf) {
        return !mf.isReference() && !mf.hasAnnotation(Serialized.class);
    }

    static boolean isCompatibleForOperator(MappedClass mappedClass, MappedField mappedField, Class<?> type, FilterOperator op, Object value, List<ValidationFailure> validationFailures) {
        if (value == null || type == null) {
            return true;
        }
        boolean validationApplied = ExistsOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || SizeOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || InOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || NotInOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || ModOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || GeoWithinOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || AllOperationValidator.getInstance().apply(mappedField, op, value, validationFailures) || KeyValueTypeValidator.getInstance().apply(type, value, validationFailures) || IntegerTypeValidator.getInstance().apply(type, value, validationFailures) || LongTypeValidator.getInstance().apply(type, value, validationFailures) || DoubleTypeValidator.getInstance().apply(type, value, validationFailures) || PatternValueValidator.getInstance().apply(type, value, validationFailures) || EntityAnnotatedValueValidator.getInstance().apply(type, value, validationFailures) || ListValueValidator.getInstance().apply(type, value, validationFailures) || EntityTypeAndIdValueValidator.getInstance().apply(mappedClass, mappedField, value, validationFailures) || DefaultTypeValidator.getInstance().apply(type, value, validationFailures);
        return validationApplied && validationFailures.size() == 0;
    }
}

