/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query;

import java.util.Arrays;
import java.util.List;

public enum FilterOperator {
    WITHIN_CIRCLE("$center", new String[0]),
    WITHIN_CIRCLE_SPHERE("$centerSphere", new String[0]),
    WITHIN_BOX("$box", new String[0]),
    EQUAL("$eq", "=", "=="),
    NOT_EQUAL("$ne", "!=", "<>"),
    GREATER_THAN("$gt", ">"),
    GREATER_THAN_OR_EQUAL("$gte", ">="),
    LESS_THAN("$lt", "<"),
    LESS_THAN_OR_EQUAL("$lte", "<="),
    EXISTS("$exists", "exists"),
    TYPE("$type", "type"),
    NOT("$not", new String[0]),
    MOD("$mod", "mod"),
    SIZE("$size", "size"),
    IN("$in", "in"),
    NOT_IN("$nin", "nin"),
    ALL("$all", "all"),
    ELEMENT_MATCH("$elemMatch", "elem", "elemMatch"),
    WHERE("$where", new String[0]),
    NEAR("$near", "near"),
    NEAR_SPHERE("$nearSphere", new String[0]),
    WITHIN("$within", "within"),
    GEO_NEAR("$geoNear", "geoNear"),
    GEO_WITHIN("$geoWithin", "geoWithin"),
    INTERSECTS("$geoIntersects", "geoIntersects");

    private final String value;
    private final List<String> filters;

    private FilterOperator(String val, String ... filterValues) {
        this.value = val;
        this.filters = Arrays.asList(filterValues);
    }

    public static FilterOperator fromString(String operator) {
        String filter = operator.trim().toLowerCase();
        for (FilterOperator filterOperator : FilterOperator.values()) {
            if (!filterOperator.matches(filter)) continue;
            return filterOperator;
        }
        throw new IllegalArgumentException(String.format("Unknown operator '%s'", operator));
    }

    public boolean matches(String filter) {
        return filter != null && this.filters.contains(filter.trim().toLowerCase());
    }

    public String val() {
        return this.value;
    }
}

