/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.query;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.lucko.helper.mongo.external.mongodriver.BasicDBObject;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.morphia.logging.Logger;
import me.lucko.helper.mongo.external.morphia.logging.MorphiaLoggerFactory;
import me.lucko.helper.mongo.external.morphia.mapping.MappedClass;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.Mapper;
import me.lucko.helper.mongo.external.morphia.query.AbstractCriteria;
import me.lucko.helper.mongo.external.morphia.query.FilterOperator;
import me.lucko.helper.mongo.external.morphia.query.QueryImpl;
import me.lucko.helper.mongo.external.morphia.query.QueryValidator;
import me.lucko.helper.mongo.external.morphia.utils.ReflectionUtils;

class FieldCriteria
extends AbstractCriteria {
    private static final Logger LOG = MorphiaLoggerFactory.get(FieldCriteria.class);
    private final String field;
    private final FilterOperator operator;
    private final Object value;
    private final boolean not;

    FieldCriteria(QueryImpl<?> query, String field, FilterOperator op, Object value) {
        this(query, field, op, value, false);
    }

    FieldCriteria(QueryImpl<?> query, String fieldName, FilterOperator op, Object value, boolean not) {
        Class<?> type;
        StringBuilder sb = new StringBuilder(fieldName);
        Mapper mapper = query.getDatastore().getMapper();
        MappedField mf = QueryValidator.validateQuery(query.getEntityClass(), mapper, sb, op, value, query.isValidatingNames(), query.isValidatingTypes());
        MappedClass mc = null;
        try {
            if (value != null && !ReflectionUtils.isPropertyType(value.getClass()) && !ReflectionUtils.implementsInterface(value.getClass(), Iterable.class)) {
                mc = mf != null && !mf.isTypeMongoCompatible() ? mapper.getMappedClass(mf.isSingleValue() ? mf.getType() : mf.getSubClass()) : mapper.getMappedClass(value);
            }
        }
        catch (Exception e) {
            LOG.debug("Error during mapping of filter criteria: ", e);
        }
        List<Object> mappedValue = mapper.toMongoObject(mf, mc, value);
        Class<?> clazz = type = mappedValue == null ? null : mappedValue.getClass();
        if (!(type == null || op != FilterOperator.IN && op != FilterOperator.NOT_IN || type.isArray() || Iterable.class.isAssignableFrom(type))) {
            mappedValue = Collections.singletonList(mappedValue);
        }
        if (value != null && type == null && (op == FilterOperator.IN || op == FilterOperator.NOT_IN) && Iterable.class.isAssignableFrom(value.getClass())) {
            mappedValue = Collections.emptyList();
        }
        this.field = sb.toString();
        this.operator = op;
        this.value = mappedValue;
        this.not = not;
    }

    @Override
    public void addTo(DBObject obj) {
        if (FilterOperator.EQUAL.equals((Object)this.operator)) {
            if (this.not) {
                obj.put(this.field, new BasicDBObject("$not", this.value));
            } else {
                obj.put(this.field, this.value);
            }
        } else {
            HashMap<String, Object> inner;
            Object object = obj.get(this.field);
            if (!(object instanceof Map)) {
                inner = new HashMap<String, Object>();
                obj.put(this.field, inner);
            } else {
                inner = (HashMap<String, Object>)object;
            }
            if (this.not) {
                inner.put("$not", new BasicDBObject(this.operator.val(), this.value));
            } else {
                inner.put(this.operator.val(), this.value);
            }
        }
    }

    @Override
    public String getFieldName() {
        return this.field;
    }

    public String getField() {
        return this.field;
    }

    public FilterOperator getOperator() {
        return this.operator;
    }

    public Object getValue() {
        return this.value;
    }

    public boolean isNot() {
        return this.not;
    }

    public String toString() {
        return this.field + " " + this.operator.val() + " " + this.value;
    }
}

