/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.mapping.lazy.proxy;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.morphia.Datastore;
import me.lucko.helper.mongo.external.morphia.Key;
import me.lucko.helper.mongo.external.morphia.mapping.lazy.proxy.AbstractReference;
import me.lucko.helper.mongo.external.morphia.mapping.lazy.proxy.LazyReferenceFetchingException;
import me.lucko.helper.mongo.external.morphia.mapping.lazy.proxy.ProxiedEntityReferenceList;

public class CollectionObjectReference<T>
extends AbstractReference
implements ProxiedEntityReferenceList {
    private static final long serialVersionUID = 1L;
    private final List<Key<?>> listOfKeys;

    public CollectionObjectReference(Collection<T> type, Class<T> referenceObjClass, boolean ignoreMissing, Datastore datastore) {
        super(datastore, referenceObjClass, ignoreMissing);
        this.object = type;
        this.listOfKeys = new ArrayList();
    }

    public void __add(Key key) {
        this.listOfKeys.add(key);
    }

    @Override
    public void __addAll(Collection<? extends Key<?>> keys) {
        this.listOfKeys.addAll(keys);
    }

    @Override
    public List<Key<?>> __getKeysAsList() {
        return Collections.unmodifiableList(this.listOfKeys);
    }

    @Override
    protected void beforeWriteObject() {
        if (this.__isFetched()) {
            this.syncKeys();
            ((Collection)this.object).clear();
        }
    }

    @Override
    protected synchronized Object fetch() {
        Collection c = (Collection)this.object;
        c.clear();
        int numberOfEntitiesExpected = this.listOfKeys.size();
        ArrayList retrievedEntities = new ArrayList(this.listOfKeys.size());
        for (Key<?> k : this.listOfKeys) {
            Object entity = this.getDatastore().getByKey(this.referenceObjClass, k);
            if (entity == null) continue;
            retrievedEntities.add(entity);
        }
        if (!this.ignoreMissing && numberOfEntitiesExpected != retrievedEntities.size()) {
            throw new LazyReferenceFetchingException(String.format("During the lifetime of a proxy of type '%s', some referenced Entities of type '%s' have disappeared from the Datastore.", c.getClass().getSimpleName(), this.referenceObjClass.getSimpleName()));
        }
        c.addAll(retrievedEntities);
        return c;
    }

    private void syncKeys() {
        Datastore ds = this.getDatastore();
        this.listOfKeys.clear();
        for (Object e : (Collection)this.object) {
            this.listOfKeys.add(ds.getKey(e));
        }
    }
}

