/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.geo;

import java.util.List;
import me.lucko.helper.mongo.external.morphia.geo.Geometry;
import me.lucko.helper.mongo.external.morphia.geo.GeometryFactory;
import me.lucko.helper.mongo.external.morphia.geo.LineString;
import me.lucko.helper.mongo.external.morphia.geo.MultiLineString;
import me.lucko.helper.mongo.external.morphia.geo.MultiPoint;
import me.lucko.helper.mongo.external.morphia.geo.MultiPolygon;
import me.lucko.helper.mongo.external.morphia.geo.Point;
import me.lucko.helper.mongo.external.morphia.geo.Polygon;

public enum GeoJsonType implements GeometryFactory
{
    POINT("Point", Point.class){

        public Geometry createGeometry(List coordinates) {
            return new Point(coordinates);
        }
    }
    ,
    LINE_STRING("LineString", LineString.class){

        public Geometry createGeometry(List objects) {
            return new LineString(objects);
        }
    }
    ,
    POLYGON("Polygon", Polygon.class){

        public Geometry createGeometry(List boundaries) {
            return new Polygon(boundaries);
        }
    }
    ,
    MULTI_POINT("MultiPoint", MultiPoint.class){

        public Geometry createGeometry(List points) {
            return new MultiPoint(points);
        }
    }
    ,
    MULTI_LINE_STRING("MultiLineString", MultiLineString.class){

        public Geometry createGeometry(List lineStrings) {
            return new MultiLineString(lineStrings);
        }
    }
    ,
    MULTI_POLYGON("MultiPolygon", MultiPolygon.class){

        public Geometry createGeometry(List polygons) {
            return new MultiPolygon(polygons);
        }
    };

    private final String type;
    private final Class<? extends Geometry> typeClass;

    private GeoJsonType(String type, Class<? extends Geometry> typeClass) {
        this.type = type;
        this.typeClass = typeClass;
    }

    public static GeoJsonType fromString(String type) {
        if (type != null) {
            for (GeoJsonType geoJsonType : GeoJsonType.values()) {
                if (!type.equalsIgnoreCase(geoJsonType.getType())) continue;
                return geoJsonType;
            }
        }
        throw new IllegalArgumentException(String.format("Cannot decode type into GeoJsonType. Type= '%s'", type));
    }

    public String getType() {
        return this.type;
    }

    public Class<? extends Geometry> getTypeClass() {
        return this.typeClass;
    }
}

