/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.io.IOException;
import me.lucko.helper.mongo.external.bson.types.Binary;
import me.lucko.helper.mongo.external.morphia.annotations.Serialized;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.MappingException;
import me.lucko.helper.mongo.external.morphia.mapping.Serializer;

public class SerializedObjectConverter
extends TypeConverter {
    public Object decode(Class targetClass, Object fromDBObject, MappedField f) {
        if (fromDBObject == null) {
            return null;
        }
        if (!(fromDBObject instanceof Binary) && !(fromDBObject instanceof byte[])) {
            throw new MappingException(String.format("The stored data is not a DBBinary or byte[] instance for %s ; it is a %s", f.getFullName(), fromDBObject.getClass().getName()));
        }
        try {
            boolean useCompression = !f.getAnnotation(Serialized.class).disableCompression();
            return Serializer.deserialize(fromDBObject, useCompression);
        }
        catch (IOException e) {
            throw new MappingException("While deserializing to " + f.getFullName(), e);
        }
        catch (ClassNotFoundException e) {
            throw new MappingException("While deserializing to " + f.getFullName(), e);
        }
    }

    @Override
    public Object encode(Object value, MappedField f) {
        if (value == null) {
            return null;
        }
        try {
            boolean useCompression = !f.getAnnotation(Serialized.class).disableCompression();
            return Serializer.serialize(value, useCompression);
        }
        catch (IOException ex) {
            throw new RuntimeException(ex);
        }
    }

    protected boolean isSupported(Class c, MappedField optionalExtraInfo) {
        return optionalExtraInfo != null && optionalExtraInfo.hasAnnotation(Serialized.class);
    }
}

