/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import me.lucko.helper.mongo.external.mongodriver.DBRef;
import me.lucko.helper.mongo.external.morphia.Key;
import me.lucko.helper.mongo.external.morphia.converters.ConverterException;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;

public class KeyConverter
extends TypeConverter {
    public KeyConverter() {
        super(Key.class);
    }

    public Object decode(Class targetClass, Object o, MappedField optionalExtraInfo) {
        if (o == null) {
            return null;
        }
        if (!(o instanceof DBRef)) {
            throw new ConverterException(String.format("cannot convert %s to Key because it isn't a DBRef", o.toString()));
        }
        DBRef ref = (DBRef)o;
        MappedField actualType = this.getActualType(optionalExtraInfo);
        Class<?> keyType = actualType != null ? actualType.getConcreteType() : this.getMapper().getClassFromCollection(ref.getCollectionName());
        Key key = new Key(keyType, ref.getCollectionName(), ref.getId());
        return key;
    }

    private MappedField getActualType(MappedField field) {
        if (field == null) {
            return null;
        }
        MappedField mappedField = field.getTypeParameters().get(0);
        if (mappedField.getTypeParameters().size() != 0) {
            mappedField = this.getActualType(mappedField);
        }
        return mappedField;
    }

    @Override
    public Object encode(Object t, MappedField optionalExtraInfo) {
        if (t == null) {
            return null;
        }
        return this.getMapper().keyToDBRef((Key)t);
    }
}

