/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.lang.reflect.Array;
import java.util.List;
import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;

public class FloatConverter
extends TypeConverter
implements SimpleValueConverter {
    public FloatConverter() {
        super(Float.TYPE, Float.class, float[].class, Float[].class);
    }

    public Object decode(Class targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof Float) {
            return val;
        }
        if (val instanceof Number) {
            return Float.valueOf(((Number)val).floatValue());
        }
        if (val instanceof List) {
            Class<?> type = targetClass.isArray() ? targetClass.getComponentType() : targetClass;
            return this.convertToArray(type, (List)val);
        }
        return Float.valueOf(Float.parseFloat(val.toString()));
    }

    private Object convertToArray(Class type, List<?> values) {
        Object array = Array.newInstance(type, values.size());
        try {
            return values.toArray((Object[])array);
        }
        catch (Exception e) {
            for (int i = 0; i < values.size(); ++i) {
                Array.set(array, i, this.decode(Float.class, values.get(i)));
            }
            return array;
        }
    }
}

