/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import me.lucko.helper.mongo.external.mongodriver.BasicDBObject;
import me.lucko.helper.mongo.external.mongodriver.DBObject;
import me.lucko.helper.mongo.external.morphia.converters.BigDecimalConverter;
import me.lucko.helper.mongo.external.morphia.converters.BooleanConverter;
import me.lucko.helper.mongo.external.morphia.converters.ByteConverter;
import me.lucko.helper.mongo.external.morphia.converters.CharArrayConverter;
import me.lucko.helper.mongo.external.morphia.converters.CharacterConverter;
import me.lucko.helper.mongo.external.morphia.converters.ClassConverter;
import me.lucko.helper.mongo.external.morphia.converters.Converters;
import me.lucko.helper.mongo.external.morphia.converters.DateConverter;
import me.lucko.helper.mongo.external.morphia.converters.DoubleConverter;
import me.lucko.helper.mongo.external.morphia.converters.EnumConverter;
import me.lucko.helper.mongo.external.morphia.converters.EnumSetConverter;
import me.lucko.helper.mongo.external.morphia.converters.FloatConverter;
import me.lucko.helper.mongo.external.morphia.converters.IdentityConverter;
import me.lucko.helper.mongo.external.morphia.converters.InstantConverter;
import me.lucko.helper.mongo.external.morphia.converters.IntegerConverter;
import me.lucko.helper.mongo.external.morphia.converters.IterableConverter;
import me.lucko.helper.mongo.external.morphia.converters.KeyConverter;
import me.lucko.helper.mongo.external.morphia.converters.LocalDateConverter;
import me.lucko.helper.mongo.external.morphia.converters.LocalDateTimeConverter;
import me.lucko.helper.mongo.external.morphia.converters.LocalTimeConverter;
import me.lucko.helper.mongo.external.morphia.converters.LocaleConverter;
import me.lucko.helper.mongo.external.morphia.converters.LongConverter;
import me.lucko.helper.mongo.external.morphia.converters.MapOfValuesConverter;
import me.lucko.helper.mongo.external.morphia.converters.ObjectIdConverter;
import me.lucko.helper.mongo.external.morphia.converters.SerializedObjectConverter;
import me.lucko.helper.mongo.external.morphia.converters.ShortConverter;
import me.lucko.helper.mongo.external.morphia.converters.StringConverter;
import me.lucko.helper.mongo.external.morphia.converters.TimestampConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.converters.URIConverter;
import me.lucko.helper.mongo.external.morphia.geo.GeometryConverter;
import me.lucko.helper.mongo.external.morphia.geo.GeometryShapeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.Mapper;

public class DefaultConverters
extends Converters {
    public static final boolean JAVA_8;
    private final IdentityConverter identityConverter;
    private final SerializedObjectConverter serializedConverter;

    public DefaultConverters(Mapper mapper) {
        super(mapper);
        this.addConverter(new IdentityConverter(DBObject.class, BasicDBObject.class));
        this.addConverter(new EnumSetConverter());
        this.addConverter(new EnumConverter());
        this.addConverter(new StringConverter());
        this.addConverter(new CharacterConverter());
        this.addConverter(new ByteConverter());
        this.addConverter(new BooleanConverter());
        this.addConverter(new DoubleConverter());
        this.addConverter(new FloatConverter());
        this.addConverter(new LongConverter());
        this.addConverter(new LocaleConverter());
        this.addConverter(new ShortConverter());
        this.addConverter(new IntegerConverter());
        this.addConverter(new CharArrayConverter());
        this.addConverter(new DateConverter());
        this.addConverter(new URIConverter());
        this.addConverter(new KeyConverter());
        this.addConverter(new MapOfValuesConverter());
        this.addConverter(new IterableConverter());
        this.addConverter(new ClassConverter());
        this.addConverter(new ObjectIdConverter());
        this.addConverter(new TimestampConverter());
        this.addConverter(new BigDecimalConverter());
        this.addConverter(new GeometryShapeConverter.PointConverter());
        this.addConverter(new GeometryShapeConverter.LineStringConverter());
        this.addConverter(new GeometryShapeConverter.MultiPointConverter());
        this.addConverter(new GeometryShapeConverter.MultiLineStringConverter());
        this.addConverter(new GeometryShapeConverter.PolygonConverter());
        this.addConverter(new GeometryShapeConverter.MultiPolygonConverter());
        this.addConverter(new GeometryConverter());
        if (JAVA_8) {
            this.addConverter(LocalTimeConverter.class);
            this.addConverter(LocalDateTimeConverter.class);
            this.addConverter(LocalDateConverter.class);
            this.addConverter(InstantConverter.class);
        }
        this.identityConverter = new IdentityConverter(new Class[0]);
        this.serializedConverter = new SerializedObjectConverter();
    }

    @Override
    protected TypeConverter getEncoder(Class c) {
        TypeConverter encoder = super.getEncoder(c);
        if (encoder == null && this.identityConverter.canHandle(c)) {
            encoder = this.identityConverter;
        }
        return encoder;
    }

    @Override
    protected TypeConverter getEncoder(Object val, MappedField mf) {
        if (this.serializedConverter.canHandle(mf)) {
            return this.serializedConverter;
        }
        TypeConverter encoder = super.getEncoder(val, mf);
        if (encoder == null && (this.identityConverter.canHandle(mf) || val != null && this.identityConverter.isSupported((Class)val.getClass(), mf))) {
            encoder = this.identityConverter;
        }
        return encoder;
    }

    static {
        boolean found;
        try {
            Class.forName("java.time.LocalDateTime");
            found = true;
        }
        catch (ClassNotFoundException e) {
            found = false;
        }
        JAVA_8 = found;
    }
}

