/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.logging.Logger;
import me.lucko.helper.mongo.external.morphia.logging.MorphiaLoggerFactory;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;

public class DateConverter
extends TypeConverter
implements SimpleValueConverter {
    private static final Logger LOG = MorphiaLoggerFactory.get(DateConverter.class);

    public DateConverter() {
        this((Class)Date.class);
    }

    protected DateConverter(Class clazz) {
        super(clazz);
    }

    @Override
    public Object decode(Class<?> targetClass, Object val, MappedField optionalExtraInfo) {
        if (val == null) {
            return null;
        }
        if (val instanceof Date) {
            return val;
        }
        if (val instanceof Number) {
            return new Date(((Number)val).longValue());
        }
        if (val instanceof String) {
            try {
                return new SimpleDateFormat("EEE MMM dd kk:mm:ss z yyyy", Locale.US).parse((String)val);
            }
            catch (ParseException e) {
                LOG.error("Can't parse Date from: " + val);
            }
        }
        throw new IllegalArgumentException("Can't convert to Date from " + val);
    }
}

