/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import me.lucko.helper.mongo.external.morphia.converters.ConverterNotFoundException;
import me.lucko.helper.mongo.external.morphia.converters.Converters;
import me.lucko.helper.mongo.external.morphia.converters.DefaultConverters;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;
import me.lucko.helper.mongo.external.morphia.mapping.Mapper;

public class CustomConverters
extends Converters {
    private final DefaultConverters defaultConverters;

    public CustomConverters(Mapper mapper) {
        super(mapper);
        this.defaultConverters = new DefaultConverters(mapper);
    }

    @Override
    public boolean isRegistered(Class<? extends TypeConverter> tcClass) {
        return super.isRegistered(tcClass) || this.defaultConverters.isRegistered(tcClass);
    }

    @Override
    public void removeConverter(TypeConverter tc) {
        super.removeConverter(tc);
        this.defaultConverters.removeConverter(tc);
    }

    @Override
    protected TypeConverter getEncoder(Class c) {
        TypeConverter encoder = super.getEncoder(c);
        if (encoder == null) {
            encoder = this.defaultConverters.getEncoder(c);
        }
        if (encoder != null) {
            return encoder;
        }
        throw new ConverterNotFoundException(String.format("Cannot find encoder for %s", c.getName()));
    }

    @Override
    protected TypeConverter getEncoder(Object val, MappedField mf) {
        TypeConverter encoder = super.getEncoder(val, mf);
        if (encoder == null) {
            encoder = this.defaultConverters.getEncoder(val, mf);
        }
        if (encoder != null) {
            return encoder;
        }
        throw new ConverterNotFoundException(String.format("Cannot find encoder for %s as need for %s", mf.getType(), mf.getFullName()));
    }
}

