/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.converters;

import java.math.BigDecimal;
import java.math.BigInteger;
import me.lucko.helper.mongo.external.bson.types.Decimal128;
import me.lucko.helper.mongo.external.morphia.converters.SimpleValueConverter;
import me.lucko.helper.mongo.external.morphia.converters.TypeConverter;
import me.lucko.helper.mongo.external.morphia.mapping.MappedField;

public class BigDecimalConverter
extends TypeConverter
implements SimpleValueConverter {
    public BigDecimalConverter() {
        super(BigDecimal.class);
    }

    @Override
    public Object decode(Class<?> targetClass, Object value, MappedField optionalExtraInfo) {
        if (value == null) {
            return null;
        }
        if (value instanceof BigDecimal) {
            return value;
        }
        if (value instanceof Decimal128) {
            return ((Decimal128)value).bigDecimalValue();
        }
        if (value instanceof BigInteger) {
            return new BigDecimal((BigInteger)value);
        }
        if (value instanceof Double) {
            return new BigDecimal((Double)value);
        }
        if (value instanceof Long) {
            return new BigDecimal((Long)value);
        }
        if (value instanceof Number) {
            return new BigDecimal(((Number)value).doubleValue());
        }
        return new BigDecimal(value.toString());
    }

    @Override
    public Object encode(Object value, MappedField optionalExtraInfo) {
        if (value instanceof BigDecimal) {
            return new Decimal128((BigDecimal)value);
        }
        return super.encode(value, optionalExtraInfo);
    }
}

