/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia.aggregation;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public final class Projection {
    private final String target;
    private final String source;
    private List<Projection> projections;
    private List<Object> arguments;
    private boolean suppressed = false;

    private Projection(String field, String source) {
        this.target = field;
        this.source = "$" + source;
    }

    private Projection(String field, Projection projection, Projection ... subsequent) {
        this(field);
        this.projections = new ArrayList<Projection>();
        this.projections.add(projection);
        this.projections.addAll(Arrays.asList(subsequent));
    }

    private Projection(String field) {
        this.target = field;
        this.source = null;
    }

    private Projection(String expression, Object ... args) {
        this(expression);
        this.arguments = Arrays.asList(args);
    }

    public static Projection projection(String field) {
        return new Projection(field);
    }

    public static Projection projection(String field, String projectedField) {
        return new Projection(field, projectedField);
    }

    public static Projection projection(String field, Projection projection, Projection ... subsequent) {
        return new Projection(field, projection, subsequent);
    }

    public static Projection expression(String operator, Object ... args) {
        return new Projection(operator, args);
    }

    public static Projection list(Object ... args) {
        return new Projection(null, args);
    }

    public static Projection add(Object ... args) {
        return Projection.expression("$add", args);
    }

    public static Projection subtract(Object arg1, Object arg2) {
        return Projection.expression("$subtract", arg1, arg2);
    }

    public static Projection multiply(Object ... args) {
        return Projection.expression("$multiply", args);
    }

    public static Projection divide(Object arg1, Object arg2) {
        return Projection.expression("$divide", arg1, arg2);
    }

    public static Projection mod(Object arg1, Object arg2) {
        return Projection.expression("$mod", arg1, arg2);
    }

    public List<Object> getArguments() {
        return this.arguments;
    }

    public String getSource() {
        return this.source;
    }

    public List<Projection> getProjections() {
        return this.projections;
    }

    public String getTarget() {
        return this.target;
    }

    public boolean isSuppressed() {
        return this.suppressed;
    }

    public Projection suppress() {
        this.suppressed = true;
        return this;
    }

    public String toString() {
        return String.format("Projection{projectedField='%s', sourceField='%s', projections=%s, suppressed=%s}", this.source, this.target, this.projections, this.suppressed);
    }
}

