/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.morphia;

import java.util.Map;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.mongodriver.DBCollection;
import me.lucko.helper.mongo.external.mongodriver.MapReduceCommand;
import me.lucko.helper.mongo.external.mongodriver.ReadPreference;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.morphia.mapping.Mapper;
import me.lucko.helper.mongo.external.morphia.query.Query;
import me.lucko.helper.mongo.external.morphia.query.QueryException;
import me.lucko.helper.mongo.external.morphia.utils.Assert;

public class MapReduceOptions<T> {
    private String outputDB;
    private String outputCollection;
    private String inputCollection;
    private String map;
    private String reduce;
    private MapReduceCommand.OutputType outputType;
    private Query query;
    private String finalize;
    private ReadPreference readPreference;
    private int limit;
    private long maxTimeMS;
    private Map<String, Object> scope;
    private boolean jsMode;
    private boolean verbose;
    private boolean bypassDocumentValidation;
    private Collation collation;
    private Class<T> resultType;

    public MapReduceOptions<T> bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    public MapReduceOptions<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    public MapReduceOptions<T> finalize(String finalize) {
        this.finalize = finalize;
        return this;
    }

    public MapReduceOptions<T> jsMode(Boolean jsMode) {
        this.jsMode = jsMode;
        return this;
    }

    public MapReduceOptions<T> limit(int limit) {
        this.limit = limit;
        return this;
    }

    public MapReduceOptions<T> map(String map) {
        Assert.parametersNotNull("map", map);
        Assert.parameterNotEmpty("map", map);
        this.map = map;
        return this;
    }

    public MapReduceOptions<T> maxTimeMS(long maxTimeMS) {
        this.maxTimeMS = maxTimeMS;
        return this;
    }

    public MapReduceOptions<T> inputCollection(String name) {
        this.inputCollection = name;
        return this;
    }

    public MapReduceOptions<T> outputCollection(String name) {
        this.outputCollection = name;
        return this;
    }

    public MapReduceOptions<T> outputDB(String outputDB) {
        this.outputDB = outputDB;
        return this;
    }

    public MapReduceOptions<T> outputType(MapReduceCommand.OutputType outputType) {
        this.outputType = outputType;
        return this;
    }

    public MapReduceOptions<T> query(Query query) {
        Assert.parametersNotNull("query", query);
        this.query = query;
        return this;
    }

    public MapReduceOptions<T> readPreference(ReadPreference preference) {
        this.readPreference = preference;
        return this;
    }

    public MapReduceOptions<T> reduce(String reduce) {
        Assert.parametersNotNull("reduce", reduce);
        Assert.parameterNotEmpty("reduce", reduce);
        this.reduce = reduce;
        return this;
    }

    public MapReduceOptions<T> resultType(Class<T> resultType) {
        this.resultType = resultType;
        return this;
    }

    public MapReduceOptions<T> scope(Map<String, Object> scope) {
        this.scope = scope;
        return this;
    }

    public MapReduceOptions<T> verbose(Boolean verbose) {
        this.verbose = verbose;
        return this;
    }

    MapReduceCommand.OutputType getOutputType() {
        return this.outputType;
    }

    Query getQuery() {
        return this.query;
    }

    Class<T> getResultType() {
        return this.resultType;
    }

    MapReduceCommand toCommand(Mapper mapper) {
        if (this.query.getOffset() != 0 || this.query.getFieldsObject() != null) {
            throw new QueryException("mapReduce does not allow the offset/retrievedFields query ");
        }
        DBCollection dbColl = this.inputCollection != null ? this.getQuery().getCollection().getDB().getCollection(this.inputCollection) : this.query.getCollection();
        String target = this.outputCollection != null ? this.outputCollection : mapper.getMappedClass(this.resultType).getCollectionName();
        MapReduceCommand command = new MapReduceCommand(dbColl, this.map, this.reduce, target, this.outputType, this.query.getQueryObject());
        command.setBypassDocumentValidation(this.bypassDocumentValidation);
        command.setCollation(this.collation);
        command.setFinalize(this.finalize);
        command.setJsMode(this.jsMode);
        command.setLimit(this.limit);
        command.setMaxTime(this.maxTimeMS, TimeUnit.MILLISECONDS);
        command.setOutputDB(this.outputDB);
        command.setReadPreference(this.readPreference);
        command.setScope(this.scope);
        command.setSort(this.query.getSortObject());
        command.setVerbose(this.verbose);
        return command;
    }
}

