/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.selector;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;
import me.lucko.helper.mongo.external.mongodriver.selector.ServerSelector;

public class ServerAddressSelector
implements ServerSelector {
    private final ServerAddress serverAddress;

    public ServerAddressSelector(ServerAddress serverAddress) {
        this.serverAddress = Assertions.notNull("serverAddress", serverAddress);
    }

    public ServerAddress getServerAddress() {
        return this.serverAddress;
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        if (clusterDescription.getByServerAddress(this.serverAddress) != null) {
            return Arrays.asList(clusterDescription.getByServerAddress(this.serverAddress));
        }
        return Collections.emptyList();
    }

    public String toString() {
        return "ServerAddressSelector{serverAddress=" + this.serverAddress + '}';
    }
}

