/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.selector;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;
import me.lucko.helper.mongo.external.mongodriver.selector.ServerSelector;

public final class CompositeServerSelector
implements ServerSelector {
    private final List<ServerSelector> serverSelectors;

    public CompositeServerSelector(List<? extends ServerSelector> serverSelectors) {
        Assertions.notNull("serverSelectors", serverSelectors);
        if (serverSelectors.isEmpty()) {
            throw new IllegalArgumentException("Server selectors can not be an empty list");
        }
        for (ServerSelector serverSelector : serverSelectors) {
            if (serverSelector != null) continue;
            throw new IllegalArgumentException("Can not have a null server selector in the list of composed selectors");
        }
        this.serverSelectors = new ArrayList<ServerSelector>();
        for (ServerSelector serverSelector : serverSelectors) {
            if (serverSelector instanceof CompositeServerSelector) {
                this.serverSelectors.addAll(((CompositeServerSelector)serverSelector).serverSelectors);
                continue;
            }
            this.serverSelectors.add(serverSelector);
        }
    }

    @Override
    public List<ServerDescription> select(ClusterDescription clusterDescription) {
        ClusterDescription curClusterDescription = clusterDescription;
        List<ServerDescription> choices = null;
        for (ServerSelector cur : this.serverSelectors) {
            choices = cur.select(curClusterDescription);
            curClusterDescription = new ClusterDescription(clusterDescription.getConnectionMode(), clusterDescription.getType(), choices, clusterDescription.getClusterSettings(), clusterDescription.getServerSettings());
        }
        return choices;
    }

    public String toString() {
        return "{serverSelectors=" + this.serverSelectors + '}';
    }
}

