/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.WriteConcernResult;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.bulk.InsertRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.operation.BaseWriteOperation;

public class InsertOperation
extends BaseWriteOperation {
    private final List<InsertRequest> insertRequests;

    public InsertOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<InsertRequest> insertRequests) {
        super(namespace, ordered, writeConcern);
        this.insertRequests = Assertions.notNull("insertRequests", insertRequests);
        Assertions.isTrueArgument("insertRequests not empty", !insertRequests.isEmpty());
    }

    public List<InsertRequest> getInsertRequests() {
        return this.insertRequests;
    }

    @Override
    protected WriteConcernResult executeProtocol(Connection connection) {
        return connection.insert(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.insertRequests);
    }

    @Override
    protected void executeProtocolAsync(AsyncConnection connection, SingleResultCallback<WriteConcernResult> callback) {
        connection.insertAsync(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.insertRequests, callback);
    }

    @Override
    protected BulkWriteResult executeCommandProtocol(Connection connection) {
        return connection.insertCommand(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), this.insertRequests);
    }

    @Override
    protected void executeCommandProtocolAsync(AsyncConnection connection, SingleResultCallback<BulkWriteResult> callback) {
        connection.insertCommandAsync(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), this.insertRequests, callback);
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.INSERT;
    }

    @Override
    protected int getCount(BulkWriteResult bulkWriteResult) {
        return 0;
    }
}

