/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonBoolean;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncWriteBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.WriteBinding;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncWriteOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandResultDocumentCodec;
import me.lucko.helper.mongo.external.mongodriver.operation.DocumentHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.FindAndModifyHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.WriteOperation;

public class FindAndDeleteOperation<T>
implements AsyncWriteOperation<T>,
WriteOperation<T> {
    private final MongoNamespace namespace;
    private final Decoder<T> decoder;
    private BsonDocument filter;
    private BsonDocument projection;
    private BsonDocument sort;
    private long maxTimeMS;
    private WriteConcern writeConcern;
    private Collation collation;

    @Deprecated
    public FindAndDeleteOperation(MongoNamespace namespace, Decoder<T> decoder) {
        this(namespace, WriteConcern.ACKNOWLEDGED, decoder);
    }

    public FindAndDeleteOperation(MongoNamespace namespace, WriteConcern writeConcern, Decoder<T> decoder) {
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
        this.decoder = Assertions.notNull("decoder", decoder);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public Decoder<T> getDecoder() {
        return this.decoder;
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public FindAndDeleteOperation<T> filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonDocument getProjection() {
        return this.projection;
    }

    public FindAndDeleteOperation<T> projection(BsonDocument projection) {
        this.projection = projection;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public FindAndDeleteOperation<T> maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public BsonDocument getSort() {
        return this.sort;
    }

    public FindAndDeleteOperation<T> sort(BsonDocument sort) {
        this.sort = sort;
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public FindAndDeleteOperation<T> collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public T execute(final WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<T>(){

            @Override
            public T call(Connection connection) {
                OperationHelper.validateCollation(connection, FindAndDeleteOperation.this.collation);
                return CommandOperationHelper.executeWrappedCommandProtocol(binding, FindAndDeleteOperation.this.namespace.getDatabaseName(), FindAndDeleteOperation.this.getCommand(connection.getDescription()), CommandResultDocumentCodec.create(FindAndDeleteOperation.this.decoder, "value"), connection, FindAndModifyHelper.<BsonDocument>transformer());
            }
        });
    }

    @Override
    public void executeAsync(final AsyncWriteBinding binding, final SingleResultCallback<T> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                    OperationHelper.validateCollation(connection, FindAndDeleteOperation.this.collation, new OperationHelper.AsyncCallableWithConnection(){

                        @Override
                        public void call(AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, FindAndDeleteOperation.this.namespace.getDatabaseName(), FindAndDeleteOperation.this.getCommand(connection.getDescription()), CommandResultDocumentCodec.create(FindAndDeleteOperation.this.decoder, "value"), connection, FindAndModifyHelper.<BsonDocument>transformer(), wrappedCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    private BsonDocument getCommand(ConnectionDescription description) {
        BsonDocument commandDocument = new BsonDocument("findandmodify", new BsonString(this.namespace.getCollectionName()));
        DocumentHelper.putIfNotNull(commandDocument, "query", this.getFilter());
        DocumentHelper.putIfNotNull(commandDocument, "fields", this.getProjection());
        DocumentHelper.putIfNotNull(commandDocument, "sort", this.getSort());
        DocumentHelper.putIfNotZero(commandDocument, "maxTimeMS", this.getMaxTime(TimeUnit.MILLISECONDS));
        commandDocument.put("remove", BsonBoolean.TRUE);
        if (OperationHelper.serverIsAtLeastVersionThreeDotTwo(description) && this.writeConcern.isAcknowledged() && !this.writeConcern.isServerDefault()) {
            commandDocument.put("writeConcern", this.writeConcern.asDocument());
        }
        if (this.collation != null) {
            commandDocument.put("collation", this.collation.asDocument());
        }
        return commandDocument;
    }
}

