/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.WriteConcernResult;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.bulk.DeleteRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.operation.BaseWriteOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;

public class DeleteOperation
extends BaseWriteOperation {
    private final List<DeleteRequest> deleteRequests;

    public DeleteOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deleteRequests) {
        super(namespace, ordered, writeConcern);
        this.deleteRequests = Assertions.notNull("removes", deleteRequests);
        Assertions.isTrueArgument("deleteRequests not empty", !deleteRequests.isEmpty());
    }

    public List<DeleteRequest> getDeleteRequests() {
        return this.deleteRequests;
    }

    @Override
    protected WriteConcernResult executeProtocol(Connection connection) {
        OperationHelper.validateWriteRequestCollations(connection, this.deleteRequests, this.getWriteConcern());
        return connection.delete(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.deleteRequests);
    }

    @Override
    protected void executeProtocolAsync(AsyncConnection connection, final SingleResultCallback<WriteConcernResult> callback) {
        OperationHelper.validateWriteRequestCollations(connection, this.deleteRequests, this.getWriteConcern(), new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    connection.deleteAsync(DeleteOperation.this.getNamespace(), DeleteOperation.this.isOrdered(), DeleteOperation.this.getWriteConcern(), DeleteOperation.this.deleteRequests, callback);
                }
            }
        });
    }

    @Override
    protected BulkWriteResult executeCommandProtocol(Connection connection) {
        OperationHelper.validateWriteRequestCollations(connection, this.deleteRequests, this.getWriteConcern());
        return connection.deleteCommand(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.deleteRequests);
    }

    @Override
    protected void executeCommandProtocolAsync(AsyncConnection connection, final SingleResultCallback<BulkWriteResult> callback) {
        OperationHelper.validateWriteRequestCollations(connection, this.deleteRequests, this.getWriteConcern(), new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    connection.deleteCommandAsync(DeleteOperation.this.getNamespace(), DeleteOperation.this.isOrdered(), DeleteOperation.this.getWriteConcern(), DeleteOperation.this.deleteRequests, callback);
                }
            }
        });
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.DELETE;
    }

    @Override
    protected int getCount(BulkWriteResult bulkWriteResult) {
        return bulkWriteResult.getDeletedCount();
    }
}

