/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.bson.BsonValue;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.mongodriver.ExplainVerbosity;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.ReadConcern;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncReadBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.ReadBinding;
import me.lucko.helper.mongo.external.mongodriver.client.model.Collation;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandOperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandReadOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.DocumentHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.ExplainHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.ReadOperation;

public class CountOperation
implements AsyncReadOperation<Long>,
ReadOperation<Long> {
    private final MongoNamespace namespace;
    private BsonDocument filter;
    private BsonValue hint;
    private long skip;
    private long limit;
    private long maxTimeMS;
    private ReadConcern readConcern = ReadConcern.DEFAULT;
    private Collation collation;

    public CountOperation(MongoNamespace namespace) {
        this.namespace = Assertions.notNull("namespace", namespace);
    }

    public BsonDocument getFilter() {
        return this.filter;
    }

    public CountOperation filter(BsonDocument filter) {
        this.filter = filter;
        return this;
    }

    public BsonValue getHint() {
        return this.hint;
    }

    public CountOperation hint(BsonValue hint) {
        this.hint = hint;
        return this;
    }

    public long getLimit() {
        return this.limit;
    }

    public CountOperation limit(long limit) {
        this.limit = limit;
        return this;
    }

    public long getSkip() {
        return this.skip;
    }

    public CountOperation skip(long skip) {
        this.skip = skip;
        return this;
    }

    public long getMaxTime(TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        return timeUnit.convert(this.maxTimeMS, TimeUnit.MILLISECONDS);
    }

    public CountOperation maxTime(long maxTime, TimeUnit timeUnit) {
        Assertions.notNull("timeUnit", timeUnit);
        this.maxTimeMS = TimeUnit.MILLISECONDS.convert(maxTime, timeUnit);
        return this;
    }

    public ReadConcern getReadConcern() {
        return this.readConcern;
    }

    public CountOperation readConcern(ReadConcern readConcern) {
        this.readConcern = Assertions.notNull("readConcern", readConcern);
        return this;
    }

    public Collation getCollation() {
        return this.collation;
    }

    public CountOperation collation(Collation collation) {
        this.collation = collation;
        return this;
    }

    @Override
    public Long execute(final ReadBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<Long>(){

            @Override
            public Long call(Connection connection) {
                OperationHelper.validateReadConcernAndCollation(connection, CountOperation.this.readConcern, CountOperation.this.collation);
                return (Long)CommandOperationHelper.executeWrappedCommandProtocol(binding, CountOperation.this.namespace.getDatabaseName(), CountOperation.this.getCommand(), (Decoder<BsonDocument>)new BsonDocumentCodec(), connection, CountOperation.this.transformer());
            }
        });
    }

    @Override
    public void executeAsync(final AsyncReadBinding binding, final SingleResultCallback<Long> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                    OperationHelper.validateReadConcernAndCollation(connection, CountOperation.this.readConcern, CountOperation.this.collation, new OperationHelper.AsyncCallableWithConnection(){

                        @Override
                        public void call(AsyncConnection connection, Throwable t) {
                            if (t != null) {
                                wrappedCallback.onResult(null, t);
                            } else {
                                CommandOperationHelper.executeWrappedCommandProtocolAsync(binding, CountOperation.this.namespace.getDatabaseName(), CountOperation.this.getCommand(), (Decoder<BsonDocument>)new BsonDocumentCodec(), connection, CountOperation.this.transformer(), wrappedCallback);
                            }
                        }
                    });
                }
            }
        });
    }

    public ReadOperation<BsonDocument> asExplainableOperation(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    public AsyncReadOperation<BsonDocument> asExplainableOperationAsync(ExplainVerbosity explainVerbosity) {
        return this.createExplainableOperation(explainVerbosity);
    }

    private CommandReadOperation<BsonDocument> createExplainableOperation(ExplainVerbosity explainVerbosity) {
        return new CommandReadOperation<BsonDocument>(this.namespace.getDatabaseName(), ExplainHelper.asExplainCommand(this.getCommand(), explainVerbosity), new BsonDocumentCodec());
    }

    private CommandOperationHelper.CommandTransformer<BsonDocument, Long> transformer() {
        return new CommandOperationHelper.CommandTransformer<BsonDocument, Long>(){

            @Override
            public Long apply(BsonDocument result, ServerAddress serverAddress) {
                return result.getNumber("n").longValue();
            }
        };
    }

    private BsonDocument getCommand() {
        BsonDocument document = new BsonDocument("count", new BsonString(this.namespace.getCollectionName()));
        DocumentHelper.putIfNotNull(document, "query", this.filter);
        DocumentHelper.putIfNotZero(document, "limit", this.limit);
        DocumentHelper.putIfNotZero(document, "skip", this.skip);
        DocumentHelper.putIfNotNull(document, "hint", this.hint);
        DocumentHelper.putIfNotZero(document, "maxTimeMS", this.maxTimeMS);
        if (!this.readConcern.isServerDefault()) {
            document.put("readConcern", this.readConcern.asDocument());
        }
        if (this.collation != null) {
            document.put("collation", this.collation.asDocument());
        }
        return document;
    }
}

