/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import me.lucko.helper.mongo.external.bson.BsonArray;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonValue;
import me.lucko.helper.mongo.external.bson.codecs.BsonArrayCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonBinaryCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonBooleanCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDBPointerCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDateTimeCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDecimal128Codec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDocumentCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonDoubleCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonInt32Codec;
import me.lucko.helper.mongo.external.bson.codecs.BsonInt64Codec;
import me.lucko.helper.mongo.external.bson.codecs.BsonJavaScriptCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonJavaScriptWithScopeCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonMaxKeyCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonMinKeyCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonNullCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonObjectIdCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonRegularExpressionCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonStringCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonSymbolCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonTimestampCodec;
import me.lucko.helper.mongo.external.bson.codecs.BsonUndefinedCodec;
import me.lucko.helper.mongo.external.bson.codecs.Codec;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecProvider;
import me.lucko.helper.mongo.external.bson.codecs.configuration.CodecRegistry;
import me.lucko.helper.mongo.external.mongodriver.operation.CommandResultDocumentCodec;

class CommandResultCodecProvider<P>
implements CodecProvider {
    private final Map<Class<?>, Codec<?>> codecs = new HashMap();
    private final Decoder<P> payloadDecoder;
    private final List<String> fieldsContainingPayload;

    CommandResultCodecProvider(Decoder<P> payloadDecoder, List<String> fieldContainingPayload) {
        this.payloadDecoder = payloadDecoder;
        this.fieldsContainingPayload = fieldContainingPayload;
        this.addCodecs();
    }

    @Override
    public <T> Codec<T> get(Class<T> clazz, CodecRegistry registry) {
        if (this.codecs.containsKey(clazz)) {
            return this.codecs.get(clazz);
        }
        if (clazz == BsonArray.class) {
            return new BsonArrayCodec(registry);
        }
        if (clazz == BsonDocument.class) {
            return new CommandResultDocumentCodec<P>(registry, this.payloadDecoder, this.fieldsContainingPayload);
        }
        return null;
    }

    private void addCodecs() {
        this.addCodec(new BsonNullCodec());
        this.addCodec(new BsonBinaryCodec());
        this.addCodec(new BsonBooleanCodec());
        this.addCodec(new BsonDateTimeCodec());
        this.addCodec(new BsonDBPointerCodec());
        this.addCodec(new BsonDoubleCodec());
        this.addCodec(new BsonInt32Codec());
        this.addCodec(new BsonInt64Codec());
        this.addCodec(new BsonDecimal128Codec());
        this.addCodec(new BsonMinKeyCodec());
        this.addCodec(new BsonMaxKeyCodec());
        this.addCodec(new BsonJavaScriptCodec());
        this.addCodec(new BsonObjectIdCodec());
        this.addCodec(new BsonRegularExpressionCodec());
        this.addCodec(new BsonStringCodec());
        this.addCodec(new BsonSymbolCodec());
        this.addCodec(new BsonTimestampCodec());
        this.addCodec(new BsonUndefinedCodec());
        this.addCodec(new BsonJavaScriptWithScopeCodec(new BsonDocumentCodec()));
    }

    private <T extends BsonValue> void addCodec(Codec<T> codec) {
        this.codecs.put(codec.getEncoderClass(), codec);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CommandResultCodecProvider that = (CommandResultCodecProvider)o;
        if (!this.fieldsContainingPayload.equals(that.fieldsContainingPayload)) {
            return false;
        }
        return this.payloadDecoder.getClass().equals(that.payloadDecoder.getClass());
    }

    public int hashCode() {
        int result = this.payloadDecoder.getClass().hashCode();
        result = 31 * result + this.fieldsContainingPayload.hashCode();
        return result;
    }
}

