/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.operation;

import me.lucko.helper.mongo.external.bson.BsonBoolean;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt32;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.mongodriver.DuplicateKeyException;
import me.lucko.helper.mongo.external.mongodriver.ErrorCategory;
import me.lucko.helper.mongo.external.mongodriver.MongoBulkWriteException;
import me.lucko.helper.mongo.external.mongodriver.MongoException;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.WriteConcernException;
import me.lucko.helper.mongo.external.mongodriver.WriteConcernResult;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.binding.AsyncWriteBinding;
import me.lucko.helper.mongo.external.mongodriver.binding.WriteBinding;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteError;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;
import me.lucko.helper.mongo.external.mongodriver.operation.AsyncWriteOperation;
import me.lucko.helper.mongo.external.mongodriver.operation.OperationHelper;
import me.lucko.helper.mongo.external.mongodriver.operation.WriteOperation;

public abstract class BaseWriteOperation
implements AsyncWriteOperation<WriteConcernResult>,
WriteOperation<WriteConcernResult> {
    private final WriteConcern writeConcern;
    private final MongoNamespace namespace;
    private final boolean ordered;
    private Boolean bypassDocumentValidation;

    public BaseWriteOperation(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern) {
        this.ordered = ordered;
        this.namespace = Assertions.notNull("namespace", namespace);
        this.writeConcern = Assertions.notNull("writeConcern", writeConcern);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public WriteConcern getWriteConcern() {
        return this.writeConcern;
    }

    public boolean isOrdered() {
        return this.ordered;
    }

    public Boolean getBypassDocumentValidation() {
        return this.bypassDocumentValidation;
    }

    public BaseWriteOperation bypassDocumentValidation(Boolean bypassDocumentValidation) {
        this.bypassDocumentValidation = bypassDocumentValidation;
        return this;
    }

    @Override
    public WriteConcernResult execute(WriteBinding binding) {
        return OperationHelper.withConnection(binding, new OperationHelper.CallableWithConnection<WriteConcernResult>(){

            @Override
            public WriteConcernResult call(Connection connection) {
                try {
                    OperationHelper.checkBypassDocumentValidationIsSupported(connection, BaseWriteOperation.this.bypassDocumentValidation, BaseWriteOperation.this.writeConcern);
                    if (BaseWriteOperation.this.writeConcern.isAcknowledged() && OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                        return BaseWriteOperation.this.translateBulkWriteResult(BaseWriteOperation.this.executeCommandProtocol(connection));
                    }
                    return BaseWriteOperation.this.executeProtocol(connection);
                }
                catch (MongoBulkWriteException e) {
                    throw BaseWriteOperation.this.convertBulkWriteException(e);
                }
            }
        });
    }

    @Override
    public void executeAsync(AsyncWriteBinding binding, final SingleResultCallback<WriteConcernResult> callback) {
        OperationHelper.withConnection(binding, new OperationHelper.AsyncCallableWithConnection(){

            @Override
            public void call(AsyncConnection connection, Throwable t) {
                final SingleResultCallback<Object> errHandlingCallback = ErrorHandlingResultCallback.errorHandlingCallback(callback, OperationHelper.LOGGER);
                if (t != null) {
                    errHandlingCallback.onResult(null, t);
                } else {
                    OperationHelper.checkBypassDocumentValidationIsSupported(connection, BaseWriteOperation.this.bypassDocumentValidation, BaseWriteOperation.this.writeConcern, new OperationHelper.AsyncCallableWithConnection(){

                        @Override
                        public void call(AsyncConnection connection, Throwable t1) {
                            if (t1 != null) {
                                OperationHelper.releasingCallback(errHandlingCallback, connection).onResult(null, t1);
                            } else {
                                final SingleResultCallback wrappedCallback = OperationHelper.releasingCallback(errHandlingCallback, connection);
                                if (BaseWriteOperation.this.writeConcern.isAcknowledged() && OperationHelper.serverIsAtLeastVersionTwoDotSix(connection.getDescription())) {
                                    BaseWriteOperation.this.executeCommandProtocolAsync(connection, new SingleResultCallback<BulkWriteResult>(){

                                        @Override
                                        public void onResult(BulkWriteResult result, Throwable t) {
                                            if (t != null) {
                                                wrappedCallback.onResult(null, BaseWriteOperation.this.translateException(t));
                                            } else {
                                                wrappedCallback.onResult(BaseWriteOperation.this.translateBulkWriteResult(result), null);
                                            }
                                        }
                                    });
                                } else {
                                    BaseWriteOperation.this.executeProtocolAsync(connection, new SingleResultCallback<WriteConcernResult>(){

                                        @Override
                                        public void onResult(WriteConcernResult result, Throwable t) {
                                            if (t != null) {
                                                wrappedCallback.onResult(null, BaseWriteOperation.this.translateException(t));
                                            } else {
                                                wrappedCallback.onResult(result, null);
                                            }
                                        }
                                    });
                                }
                            }
                        }
                    });
                }
            }
        });
    }

    protected abstract WriteConcernResult executeProtocol(Connection var1);

    protected abstract void executeProtocolAsync(AsyncConnection var1, SingleResultCallback<WriteConcernResult> var2);

    protected abstract BulkWriteResult executeCommandProtocol(Connection var1);

    protected abstract void executeCommandProtocolAsync(AsyncConnection var1, SingleResultCallback<BulkWriteResult> var2);

    private MongoException translateException(Throwable t) {
        MongoException checkedError = MongoException.fromThrowable(t);
        if (t instanceof MongoBulkWriteException) {
            checkedError = this.convertBulkWriteException((MongoBulkWriteException)t);
        }
        return checkedError;
    }

    private MongoException convertBulkWriteException(MongoBulkWriteException e) {
        BulkWriteError lastError = this.getLastError(e);
        if (lastError != null) {
            if (ErrorCategory.fromErrorCode(lastError.getCode()) == ErrorCategory.DUPLICATE_KEY) {
                return new DuplicateKeyException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
            }
            return new WriteConcernException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
        }
        return new WriteConcernException(this.manufactureGetLastErrorResponse(e), e.getServerAddress(), this.translateBulkWriteResult(e.getWriteResult()));
    }

    private BsonDocument manufactureGetLastErrorResponse(MongoBulkWriteException e) {
        BsonDocument response = new BsonDocument();
        this.addBulkWriteResultToResponse(e.getWriteResult(), response);
        if (e.getWriteConcernError() != null) {
            response.putAll(e.getWriteConcernError().getDetails());
        }
        if (this.getLastError(e) != null) {
            response.put("err", new BsonString(this.getLastError(e).getMessage()));
            response.put("code", new BsonInt32(this.getLastError(e).getCode()));
            response.putAll(this.getLastError(e).getDetails());
        } else if (e.getWriteConcernError() != null) {
            response.put("err", new BsonString(e.getWriteConcernError().getMessage()));
            response.put("code", new BsonInt32(e.getWriteConcernError().getCode()));
        }
        return response;
    }

    private void addBulkWriteResultToResponse(BulkWriteResult bulkWriteResult, BsonDocument response) {
        response.put("ok", new BsonInt32(1));
        if (this.getType() == WriteRequest.Type.INSERT) {
            response.put("n", new BsonInt32(0));
        } else if (this.getType() == WriteRequest.Type.DELETE) {
            response.put("n", new BsonInt32(bulkWriteResult.getDeletedCount()));
        } else if (this.getType() == WriteRequest.Type.UPDATE || this.getType() == WriteRequest.Type.REPLACE) {
            response.put("n", new BsonInt32(bulkWriteResult.getMatchedCount() + bulkWriteResult.getUpserts().size()));
            if (bulkWriteResult.getUpserts().isEmpty()) {
                response.put("updatedExisting", BsonBoolean.TRUE);
            } else {
                response.put("updatedExisting", BsonBoolean.FALSE);
                response.put("upserted", bulkWriteResult.getUpserts().get(0).getId());
            }
        }
    }

    private WriteConcernResult translateBulkWriteResult(BulkWriteResult bulkWriteResult) {
        return WriteConcernResult.acknowledged(this.getCount(bulkWriteResult), this.getUpdatedExisting(bulkWriteResult), bulkWriteResult.getUpserts().isEmpty() ? null : bulkWriteResult.getUpserts().get(0).getId());
    }

    protected abstract WriteRequest.Type getType();

    protected abstract int getCount(BulkWriteResult var1);

    protected boolean getUpdatedExisting(BulkWriteResult bulkWriteResult) {
        return false;
    }

    private BulkWriteError getLastError(MongoBulkWriteException e) {
        return e.getWriteErrors().isEmpty() ? null : e.getWriteErrors().get(e.getWriteErrors().size() - 1);
    }
}

