/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.internal.connection;

import java.util.Deque;
import java.util.Iterator;
import java.util.concurrent.Semaphore;
import java.util.concurrent.TimeUnit;
import me.lucko.helper.mongo.external.mongodriver.MongoInternalException;
import me.lucko.helper.mongo.external.mongodriver.MongoInterruptedException;
import me.lucko.helper.mongo.external.mongodriver.MongoTimeoutException;
import me.lucko.helper.mongo.external.mongodriver.internal.connection.ConcurrentLinkedDeque;
import me.lucko.helper.mongo.external.mongodriver.internal.connection.Pool;

public class ConcurrentPool<T>
implements Pool<T> {
    private final int maxSize;
    private final ItemFactory<T> itemFactory;
    private final Deque<T> available = new ConcurrentLinkedDeque<T>();
    private final Semaphore permits;
    private volatile boolean closed;

    public ConcurrentPool(int maxSize, ItemFactory<T> itemFactory) {
        this.maxSize = maxSize;
        this.itemFactory = itemFactory;
        this.permits = new Semaphore(maxSize, true);
    }

    @Override
    public void release(T t) {
        this.release(t, false);
    }

    @Override
    public void release(T t, boolean prune) {
        if (t == null) {
            throw new IllegalArgumentException("Can not return a null item to the pool");
        }
        if (this.closed) {
            this.close(t);
            return;
        }
        if (prune) {
            this.close(t);
        } else {
            this.available.addLast(t);
        }
        this.releasePermit();
    }

    @Override
    public T get() {
        return this.get(-1L, TimeUnit.MILLISECONDS);
    }

    @Override
    public T get(long timeout, TimeUnit timeUnit) {
        if (this.closed) {
            throw new IllegalStateException("The pool is closed");
        }
        if (!this.acquirePermit(timeout, timeUnit)) {
            throw new MongoTimeoutException(String.format("Timeout waiting for a pooled item after %d %s", new Object[]{timeout, timeUnit}));
        }
        T t = this.available.pollLast();
        if (t == null) {
            t = this.createNewAndReleasePermitIfFailure(false);
        }
        return t;
    }

    public void prune() {
        int currentAvailableCount = this.getAvailableCount();
        for (int numAttempts = 0; numAttempts < currentAvailableCount && this.acquirePermit(10L, TimeUnit.MILLISECONDS); ++numAttempts) {
            T cur = this.available.pollFirst();
            if (cur == null) {
                this.releasePermit();
                break;
            }
            this.release(cur, this.itemFactory.shouldPrune(cur));
        }
    }

    public void ensureMinSize(int minSize, boolean initialize) {
        while (this.getCount() < minSize && this.acquirePermit(10L, TimeUnit.MILLISECONDS)) {
            this.release(this.createNewAndReleasePermitIfFailure(initialize));
        }
    }

    private T createNewAndReleasePermitIfFailure(boolean initialize) {
        try {
            T newMember = this.itemFactory.create(initialize);
            if (newMember == null) {
                throw new MongoInternalException("The factory for the pool created a null item");
            }
            return newMember;
        }
        catch (RuntimeException e) {
            this.permits.release();
            throw e;
        }
    }

    protected boolean acquirePermit(long timeout, TimeUnit timeUnit) {
        try {
            if (this.closed) {
                return false;
            }
            if (timeout >= 0L) {
                return this.permits.tryAcquire(timeout, timeUnit);
            }
            this.permits.acquire();
            return true;
        }
        catch (InterruptedException e) {
            throw new MongoInterruptedException("Interrupted acquiring a permit to retrieve an item from the pool ", e);
        }
    }

    protected void releasePermit() {
        this.permits.release();
    }

    @Override
    public void close() {
        this.closed = true;
        Iterator<T> iter = this.available.iterator();
        while (iter.hasNext()) {
            T t = iter.next();
            this.close(t);
            iter.remove();
        }
    }

    public int getMaxSize() {
        return this.maxSize;
    }

    public int getInUseCount() {
        return this.maxSize - this.permits.availablePermits();
    }

    public int getAvailableCount() {
        return this.available.size();
    }

    public int getCount() {
        return this.getInUseCount() + this.getAvailableCount();
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("pool: ").append(" maxSize: ").append(this.maxSize).append(" availableCount ").append(this.getAvailableCount()).append(" inUseCount ").append(this.getInUseCount());
        return buf.toString();
    }

    private void close(T t) {
        try {
            this.itemFactory.close(t);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
    }

    public static interface ItemFactory<T> {
        public T create(boolean var1);

        public void close(T var1);

        public boolean shouldPrune(T var1);
    }
}

