/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonArray;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonInt32;
import me.lucko.helper.mongo.external.bson.BsonNumber;
import me.lucko.helper.mongo.external.bson.BsonValue;
import me.lucko.helper.mongo.external.mongodriver.MongoBulkWriteException;
import me.lucko.helper.mongo.external.mongodriver.MongoInternalException;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteError;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteUpsert;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteConcernError;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;

final class WriteCommandResultHelper {
    static boolean hasError(BsonDocument result) {
        return result.get("writeErrors") != null || result.get("writeConcernError") != null;
    }

    static BulkWriteResult getBulkWriteResult(WriteRequest.Type type, BsonDocument result) {
        int count = WriteCommandResultHelper.getCount(result);
        List<BulkWriteUpsert> upsertedItems = WriteCommandResultHelper.getUpsertedItems(result);
        return BulkWriteResult.acknowledged(type, count - upsertedItems.size(), WriteCommandResultHelper.getModifiedCount(type, result), upsertedItems);
    }

    static MongoBulkWriteException getBulkWriteException(WriteRequest.Type type, BsonDocument result, ServerAddress serverAddress) {
        if (!WriteCommandResultHelper.hasError(result)) {
            throw new MongoInternalException("This method should not have been called");
        }
        return new MongoBulkWriteException(WriteCommandResultHelper.getBulkWriteResult(type, result), WriteCommandResultHelper.getWriteErrors(result), WriteCommandResultHelper.getWriteConcernError(result), serverAddress);
    }

    private static List<BulkWriteError> getWriteErrors(BsonDocument result) {
        ArrayList<BulkWriteError> writeErrors = new ArrayList<BulkWriteError>();
        BsonArray writeErrorsDocuments = (BsonArray)result.get("writeErrors");
        if (writeErrorsDocuments != null) {
            for (BsonValue cur : writeErrorsDocuments) {
                BsonDocument curDocument = (BsonDocument)cur;
                writeErrors.add(new BulkWriteError(curDocument.getNumber("code").intValue(), curDocument.getString("errmsg").getValue(), curDocument.getDocument("errInfo", new BsonDocument()), curDocument.getNumber("index").intValue()));
            }
        }
        return writeErrors;
    }

    private static WriteConcernError getWriteConcernError(BsonDocument result) {
        BsonDocument writeConcernErrorDocument = (BsonDocument)result.get("writeConcernError");
        if (writeConcernErrorDocument == null) {
            return null;
        }
        return new WriteConcernError(writeConcernErrorDocument.getNumber("code").intValue(), writeConcernErrorDocument.getString("errmsg").getValue(), writeConcernErrorDocument.getDocument("errInfo", new BsonDocument()));
    }

    private static List<BulkWriteUpsert> getUpsertedItems(BsonDocument result) {
        BsonValue upsertedValue = result.get("upserted");
        if (upsertedValue == null) {
            return Collections.emptyList();
        }
        ArrayList<BulkWriteUpsert> bulkWriteUpsertList = new ArrayList<BulkWriteUpsert>();
        for (BsonValue upsertedItem : (BsonArray)upsertedValue) {
            BsonDocument upsertedItemDocument = (BsonDocument)upsertedItem;
            bulkWriteUpsertList.add(new BulkWriteUpsert(upsertedItemDocument.getNumber("index").intValue(), upsertedItemDocument.get("_id")));
        }
        return bulkWriteUpsertList;
    }

    private static int getCount(BsonDocument result) {
        return result.getNumber("n").intValue();
    }

    private static Integer getModifiedCount(WriteRequest.Type type, BsonDocument result) {
        BsonNumber modifiedCount = result.getNumber("nModified", type == WriteRequest.Type.UPDATE || type == WriteRequest.Type.REPLACE ? null : new BsonInt32(0));
        return modifiedCount == null ? null : Integer.valueOf(modifiedCount.intValue());
    }

    private WriteCommandResultHelper() {
    }
}

