/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.List;
import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.bulk.UpdateRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.RequestMessage;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.CollectibleDocumentFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.UpdateFieldNameValidator;

class UpdateMessage
extends RequestMessage {
    private final List<UpdateRequest> updates;

    UpdateMessage(String collectionName, List<UpdateRequest> updates, MessageSettings settings) {
        super(collectionName, RequestMessage.OpCode.OP_UPDATE, settings);
        this.updates = updates;
    }

    public List<UpdateRequest> getUpdateRequests() {
        return this.updates;
    }

    @Override
    protected RequestMessage encodeMessageBody(BsonOutput bsonOutput, int messageStartPosition) {
        return this.encodeMessageBodyWithMetadata(bsonOutput, messageStartPosition).getNextMessage();
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, int messageStartPosition) {
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(this.getCollectionName());
        UpdateRequest updateRequest = this.updates.get(0);
        int flags = 0;
        if (updateRequest.isUpsert()) {
            flags |= 1;
        }
        if (updateRequest.isMulti()) {
            flags |= 2;
        }
        bsonOutput.writeInt32(flags);
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(updateRequest.getFilter(), bsonOutput, new NoOpFieldNameValidator());
        if (updateRequest.getType() == WriteRequest.Type.REPLACE) {
            this.addCollectibleDocument(updateRequest.getUpdate(), bsonOutput, new CollectibleDocumentFieldNameValidator());
        } else {
            int bufferPosition = bsonOutput.getPosition();
            this.addDocument(updateRequest.getUpdate(), bsonOutput, new UpdateFieldNameValidator());
            if (bsonOutput.getPosition() == bufferPosition + 5) {
                throw new IllegalArgumentException("Invalid BSON document for an update");
            }
        }
        if (this.updates.size() == 1) {
            return new RequestMessage.EncodingMetadata(null, firstDocumentStartPosition);
        }
        return new RequestMessage.EncodingMetadata(new UpdateMessage(this.getCollectionName(), this.updates.subList(1, this.updates.size()), this.getSettings()), firstDocumentStartPosition);
    }
}

