/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonBinaryWriter;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.FieldNameValidator;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.bulk.UpdateRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.BaseWriteCommandMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.CollectibleDocumentFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.MappedFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.UpdateFieldNameValidator;

class UpdateCommandMessage
extends BaseWriteCommandMessage {
    private final List<UpdateRequest> updates;

    UpdateCommandMessage(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, MessageSettings settings, List<UpdateRequest> updates) {
        super(namespace, ordered, writeConcern, bypassDocumentValidation, settings);
        this.updates = updates;
    }

    public List<UpdateRequest> getRequests() {
        return Collections.unmodifiableList(this.updates);
    }

    @Override
    protected UpdateCommandMessage writeTheWrites(BsonOutput bsonOutput, int commandStartPosition, BsonBinaryWriter writer) {
        UpdateCommandMessage nextMessage = null;
        writer.writeStartArray("updates");
        for (int i = 0; i < this.updates.size(); ++i) {
            writer.mark();
            UpdateRequest update = this.updates.get(i);
            writer.writeStartDocument();
            writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
            writer.writeName("q");
            this.getCodec(update.getFilter()).encode(writer, update.getFilter(), EncoderContext.builder().build());
            writer.writeName("u");
            int bufferPosition = bsonOutput.getPosition();
            this.getCodec(update.getUpdate()).encode(writer, update.getUpdate(), EncoderContext.builder().build());
            if (update.getType() == WriteRequest.Type.UPDATE && bsonOutput.getPosition() == bufferPosition + 8) {
                throw new IllegalArgumentException("Invalid BSON document for an update");
            }
            if (update.isMulti()) {
                writer.writeBoolean("multi", update.isMulti());
            }
            if (update.isUpsert()) {
                writer.writeBoolean("upsert", update.isUpsert());
            }
            if (update.getCollation() != null) {
                writer.writeName("collation");
                BsonDocument collation = update.getCollation().asDocument();
                this.getCodec(collation).encode(writer, collation, EncoderContext.builder().build());
            }
            writer.popMaxDocumentSize();
            writer.writeEndDocument();
            if (!this.exceedsLimits(bsonOutput.getPosition() - commandStartPosition, i + 1)) continue;
            writer.reset();
            nextMessage = new UpdateCommandMessage(this.getWriteNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), this.getSettings(), this.updates.subList(i, this.updates.size()));
            break;
        }
        writer.writeEndArray();
        return nextMessage;
    }

    @Override
    public int getItemCount() {
        return this.updates.size();
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        HashMap<String, FieldNameValidator> rootMap = new HashMap<String, FieldNameValidator>();
        rootMap.put("updates", new UpdatesValidator());
        return new MappedFieldNameValidator(new NoOpFieldNameValidator(), rootMap);
    }

    @Override
    protected String getCommandName() {
        return "update";
    }

    private class UpdatesValidator
    implements FieldNameValidator {
        private int i = 0;

        private UpdatesValidator() {
        }

        @Override
        public boolean validate(String fieldName) {
            return true;
        }

        @Override
        public FieldNameValidator getValidatorForField(String fieldName) {
            if (!fieldName.equals("u")) {
                return new NoOpFieldNameValidator();
            }
            UpdateRequest updateRequest = UpdateCommandMessage.this.getRequests().get(this.i);
            ++this.i;
            if (updateRequest.getType() == WriteRequest.Type.REPLACE) {
                return new CollectibleDocumentFieldNameValidator();
            }
            return new UpdateFieldNameValidator();
        }
    }
}

