/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.io.Closeable;
import me.lucko.helper.mongo.external.bson.ByteBuf;
import me.lucko.helper.mongo.external.mongodriver.connection.ReplyHeader;

class ResponseBuffers
implements Closeable {
    private final ReplyHeader replyHeader;
    private final ByteBuf bodyByteBuffer;
    private volatile boolean isClosed;

    ResponseBuffers(ReplyHeader replyHeader, ByteBuf bodyByteBuffer) {
        this.replyHeader = replyHeader;
        this.bodyByteBuffer = bodyByteBuffer;
    }

    public ReplyHeader getReplyHeader() {
        return this.replyHeader;
    }

    public ByteBuf getBodyByteBuffer() {
        return this.bodyByteBuffer.asReadOnly();
    }

    public void reset() {
        this.bodyByteBuffer.position(0);
    }

    @Override
    public void close() {
        if (!this.isClosed) {
            if (this.bodyByteBuffer != null) {
                this.bodyByteBuffer.release();
            }
            this.isClosed = true;
        }
    }
}

