/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonBinaryReader;
import me.lucko.helper.mongo.external.bson.codecs.Decoder;
import me.lucko.helper.mongo.external.bson.codecs.DecoderContext;
import me.lucko.helper.mongo.external.bson.io.ByteBufferBsonInput;
import me.lucko.helper.mongo.external.mongodriver.MongoInternalException;
import me.lucko.helper.mongo.external.mongodriver.connection.ReplyHeader;
import me.lucko.helper.mongo.external.mongodriver.connection.ResponseBuffers;

class ReplyMessage<T> {
    private final ReplyHeader replyHeader;
    private final List<T> documents;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    ReplyMessage(ResponseBuffers responseBuffers, Decoder<T> decoder, long requestId) {
        this(responseBuffers.getReplyHeader(), requestId);
        if (this.replyHeader.getNumberReturned() > 0) {
            ByteBufferBsonInput bsonInput = new ByteBufferBsonInput(responseBuffers.getBodyByteBuffer());
            while (this.documents.size() < this.replyHeader.getNumberReturned()) {
                BsonBinaryReader reader = new BsonBinaryReader(bsonInput);
                try {
                    this.documents.add(decoder.decode(reader, DecoderContext.builder().build()));
                }
                finally {
                    reader.close();
                }
            }
        }
    }

    ReplyMessage(ReplyHeader replyHeader, long requestId) {
        if (requestId != (long)replyHeader.getResponseTo()) {
            throw new MongoInternalException(String.format("The responseTo (%d) in the response does not match the requestId (%d) in the request", replyHeader.getResponseTo(), requestId));
        }
        this.replyHeader = replyHeader;
        this.documents = new ArrayList<T>(replyHeader.getNumberReturned());
    }

    public ReplyHeader getReplyHeader() {
        return this.replyHeader;
    }

    public List<T> getDocuments() {
        return this.documents;
    }
}

