/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.ServerCursor;
import me.lucko.helper.mongo.external.mongodriver.connection.ReplyMessage;

public class QueryResult<T> {
    private final MongoNamespace namespace;
    private final List<T> results;
    private final long cursorId;
    private final ServerAddress serverAddress;

    public QueryResult(MongoNamespace namespace, List<T> results, long cursorId, ServerAddress serverAddress) {
        this.namespace = namespace;
        this.results = results;
        this.cursorId = cursorId;
        this.serverAddress = serverAddress;
    }

    QueryResult(MongoNamespace namespace, ReplyMessage<T> replyMessage, ServerAddress address) {
        this(namespace, replyMessage.getDocuments(), replyMessage.getReplyHeader().getCursorId(), address);
    }

    public MongoNamespace getNamespace() {
        return this.namespace;
    }

    public ServerCursor getCursor() {
        return this.cursorId == 0L ? null : new ServerCursor(this.cursorId, this.serverAddress);
    }

    public List<T> getResults() {
        return this.results;
    }

    public ServerAddress getAddress() {
        return this.serverAddress;
    }
}

