/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.NameCallback;
import javax.security.auth.callback.PasswordCallback;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.security.sasl.Sasl;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslException;
import me.lucko.helper.mongo.external.mongodriver.AuthenticationMechanism;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.MongoSecurityException;
import me.lucko.helper.mongo.external.mongodriver.ServerAddress;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.connection.SaslAuthenticator;

class PlainAuthenticator
extends SaslAuthenticator {
    private static final String DEFAULT_PROTOCOL = "mongodb";

    PlainAuthenticator(MongoCredential credential) {
        super(credential);
    }

    @Override
    public String getMechanismName() {
        return AuthenticationMechanism.PLAIN.getMechanismName();
    }

    @Override
    protected SaslClient createSaslClient(ServerAddress serverAddress) {
        final MongoCredential credential = this.getCredential();
        Assertions.isTrue("mechanism is PLAIN", credential.getAuthenticationMechanism() == AuthenticationMechanism.PLAIN);
        try {
            return Sasl.createSaslClient(new String[]{AuthenticationMechanism.PLAIN.getMechanismName()}, credential.getUserName(), DEFAULT_PROTOCOL, serverAddress.getHost(), null, new CallbackHandler(){

                @Override
                public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
                    for (Callback callback : callbacks) {
                        if (callback instanceof PasswordCallback) {
                            ((PasswordCallback)callback).setPassword(credential.getPassword());
                            continue;
                        }
                        if (!(callback instanceof NameCallback)) continue;
                        ((NameCallback)callback).setName(credential.getUserName());
                    }
                }
            });
        }
        catch (SaslException e) {
            throw new MongoSecurityException(credential, "Exception initializing SASL client", (Throwable)e);
        }
    }
}

