/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.BsonString;
import me.lucko.helper.mongo.external.mongodriver.MongoCommandException;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.MongoSecurityException;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.connection.Authenticator;
import me.lucko.helper.mongo.external.mongodriver.connection.CommandHelper;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.internal.authentication.NativeAuthenticationHelper;

class NativeAuthenticator
extends Authenticator {
    NativeAuthenticator(MongoCredential credential) {
        super(credential);
    }

    @Override
    public void authenticate(InternalConnection connection, ConnectionDescription connectionDescription) {
        try {
            BsonDocument nonceResponse = CommandHelper.executeCommand(this.getCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), connection);
            BsonDocument authCommand = NativeAuthenticationHelper.getAuthCommand(this.getCredential().getUserName(), this.getCredential().getPassword(), ((BsonString)nonceResponse.get("nonce")).getValue());
            CommandHelper.executeCommand(this.getCredential().getSource(), authCommand, connection);
        }
        catch (MongoCommandException e) {
            throw new MongoSecurityException(this.getCredential(), "Exception authenticating", (Throwable)e);
        }
    }

    @Override
    void authenticateAsync(final InternalConnection connection, ConnectionDescription connectionDescription, final SingleResultCallback<Void> callback) {
        CommandHelper.executeCommandAsync(this.getCredential().getSource(), NativeAuthenticationHelper.getNonceCommand(), connection, new SingleResultCallback<BsonDocument>(){

            @Override
            public void onResult(BsonDocument nonceResult, Throwable t) {
                if (t != null) {
                    callback.onResult(null, NativeAuthenticator.this.translateThrowable(t));
                } else {
                    CommandHelper.executeCommandAsync(NativeAuthenticator.this.getCredential().getSource(), NativeAuthenticationHelper.getAuthCommand(NativeAuthenticator.this.getCredential().getUserName(), NativeAuthenticator.this.getCredential().getPassword(), ((BsonString)nonceResult.get("nonce")).getValue()), connection, new SingleResultCallback<BsonDocument>(){

                        @Override
                        public void onResult(BsonDocument result, Throwable t) {
                            if (t != null) {
                                callback.onResult(null, NativeAuthenticator.this.translateThrowable(t));
                            } else {
                                callback.onResult(null, null);
                            }
                        }
                    });
                }
            }
        });
    }

    private Throwable translateThrowable(Throwable t) {
        if (t instanceof MongoCommandException) {
            return new MongoSecurityException(this.getCredential(), "Exception authenticating", t);
        }
        return t;
    }
}

