/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.ArrayList;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.mongodriver.MongoCredential;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.client.MongoDriverInformation;
import me.lucko.helper.mongo.external.mongodriver.connection.Authenticator;
import me.lucko.helper.mongo.external.mongodriver.connection.ClientMetadataHelper;
import me.lucko.helper.mongo.external.mongodriver.connection.DefaultAuthenticator;
import me.lucko.helper.mongo.external.mongodriver.connection.GSSAPIAuthenticator;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnectionFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalStreamConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalStreamConnectionInitializer;
import me.lucko.helper.mongo.external.mongodriver.connection.NativeAuthenticator;
import me.lucko.helper.mongo.external.mongodriver.connection.PlainAuthenticator;
import me.lucko.helper.mongo.external.mongodriver.connection.ScramSha1Authenticator;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerId;
import me.lucko.helper.mongo.external.mongodriver.connection.StreamFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.X509Authenticator;

class InternalStreamConnectionFactory
implements InternalConnectionFactory {
    private final StreamFactory streamFactory;
    private final BsonDocument clientMetadataDocument;
    private final List<Authenticator> authenticators;

    InternalStreamConnectionFactory(StreamFactory streamFactory, List<MongoCredential> credentialList, String applicationName, MongoDriverInformation mongoDriverInformation) {
        this.streamFactory = Assertions.notNull("streamFactory", streamFactory);
        this.clientMetadataDocument = ClientMetadataHelper.createClientMetadataDocument(applicationName, mongoDriverInformation);
        Assertions.notNull("credentialList", credentialList);
        this.authenticators = new ArrayList<Authenticator>(credentialList.size());
        for (MongoCredential credential : credentialList) {
            this.authenticators.add(this.createAuthenticator(credential));
        }
    }

    @Override
    public InternalConnection create(ServerId serverId) {
        return new InternalStreamConnection(serverId, this.streamFactory, new InternalStreamConnectionInitializer(this.authenticators, this.clientMetadataDocument));
    }

    private Authenticator createAuthenticator(MongoCredential credential) {
        if (credential.getAuthenticationMechanism() == null) {
            return new DefaultAuthenticator(credential);
        }
        switch (credential.getAuthenticationMechanism()) {
            case GSSAPI: {
                return new GSSAPIAuthenticator(credential);
            }
            case PLAIN: {
                return new PlainAuthenticator(credential);
            }
            case MONGODB_X509: {
                return new X509Authenticator(credential);
            }
            case SCRAM_SHA_1: {
                return new ScramSha1Authenticator(credential);
            }
            case MONGODB_CR: {
                return new NativeAuthenticator(credential);
            }
        }
        throw new IllegalArgumentException("Unsupported authentication mechanism " + (Object)((Object)credential.getAuthenticationMechanism()));
    }
}

