/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.bulk.InsertRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.InsertCommandMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.WriteCommandProtocol;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Logger;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Loggers;

class InsertCommandProtocol
extends WriteCommandProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.insert");
    private final List<InsertRequest> insertRequests;

    InsertCommandProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, Boolean bypassDocumentValidation, List<InsertRequest> insertRequests) {
        super(namespace, ordered, writeConcern, bypassDocumentValidation);
        this.insertRequests = insertRequests;
    }

    @Override
    public BulkWriteResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Inserting %d documents into namespace %s on connection [%s] to server %s", this.insertRequests.size(), this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        BulkWriteResult writeResult = super.execute(connection);
        LOGGER.debug("Insert completed");
        return writeResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<BulkWriteResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously inserting %d documents into namespace %s on connection [%s] to server %s", this.insertRequests.size(), this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<BulkWriteResult>(){

                @Override
                public void onResult(BulkWriteResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous insert completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.INSERT;
    }

    @Override
    protected InsertCommandMessage createRequestMessage(MessageSettings messageSettings) {
        return new InsertCommandMessage(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), this.getBypassDocumentValidation(), messageSettings, this.insertRequests);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

