/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.List;
import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.bulk.DeleteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.RequestMessage;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;

class DeleteMessage
extends RequestMessage {
    private final List<DeleteRequest> deleteRequests;

    DeleteMessage(String collectionName, List<DeleteRequest> deletes, MessageSettings settings) {
        super(collectionName, RequestMessage.OpCode.OP_DELETE, settings);
        this.deleteRequests = deletes;
    }

    @Override
    protected RequestMessage encodeMessageBody(BsonOutput bsonOutput, int messageStartPosition) {
        return this.encodeMessageBodyWithMetadata(bsonOutput, messageStartPosition).getNextMessage();
    }

    @Override
    protected RequestMessage.EncodingMetadata encodeMessageBodyWithMetadata(BsonOutput bsonOutput, int messageStartPosition) {
        DeleteRequest deleteRequest = this.deleteRequests.get(0);
        bsonOutput.writeInt32(0);
        bsonOutput.writeCString(this.getCollectionName());
        if (deleteRequest.isMulti()) {
            bsonOutput.writeInt32(0);
        } else {
            bsonOutput.writeInt32(1);
        }
        int firstDocumentStartPosition = bsonOutput.getPosition();
        this.addDocument(deleteRequest.getFilter(), bsonOutput, new NoOpFieldNameValidator());
        if (this.deleteRequests.size() == 1) {
            return new RequestMessage.EncodingMetadata(null, firstDocumentStartPosition);
        }
        return new RequestMessage.EncodingMetadata(new DeleteMessage(this.getCollectionName(), this.deleteRequests.subList(1, this.deleteRequests.size()), this.getSettings()), firstDocumentStartPosition);
    }
}

