/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.List;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.bulk.BulkWriteResult;
import me.lucko.helper.mongo.external.mongodriver.bulk.DeleteRequest;
import me.lucko.helper.mongo.external.mongodriver.bulk.WriteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.DeleteCommandMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.connection.WriteCommandProtocol;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Logger;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Loggers;

class DeleteCommandProtocol
extends WriteCommandProtocol {
    private static final Logger LOGGER = Loggers.getLogger("protocol.delete");
    private final List<DeleteRequest> deleteRequests;

    DeleteCommandProtocol(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, List<DeleteRequest> deletes) {
        super(namespace, ordered, writeConcern, null);
        this.deleteRequests = Assertions.notNull("removes", deletes);
    }

    @Override
    public BulkWriteResult execute(InternalConnection connection) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug(String.format("Deleting documents from namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
        }
        BulkWriteResult writeResult = super.execute(connection);
        LOGGER.debug("Delete completed");
        return writeResult;
    }

    @Override
    public void executeAsync(InternalConnection connection, final SingleResultCallback<BulkWriteResult> callback) {
        try {
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug(String.format("Asynchronously deleting documents from namespace %s on connection [%s] to server %s", this.getNamespace(), connection.getDescription().getConnectionId(), connection.getDescription().getServerAddress()));
            }
            super.executeAsync(connection, new SingleResultCallback<BulkWriteResult>(){

                @Override
                public void onResult(BulkWriteResult result, Throwable t) {
                    if (t != null) {
                        callback.onResult(null, t);
                    } else {
                        LOGGER.debug("Asynchronous delete completed");
                        callback.onResult(result, null);
                    }
                }
            });
        }
        catch (Throwable t) {
            callback.onResult(null, t);
        }
    }

    @Override
    protected WriteRequest.Type getType() {
        return WriteRequest.Type.DELETE;
    }

    @Override
    protected DeleteCommandMessage createRequestMessage(MessageSettings messageSettings) {
        return new DeleteCommandMessage(this.getNamespace(), this.isOrdered(), this.getWriteConcern(), messageSettings, this.deleteRequests);
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }
}

