/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import java.util.Collections;
import java.util.List;
import me.lucko.helper.mongo.external.bson.BsonBinaryWriter;
import me.lucko.helper.mongo.external.bson.BsonDocument;
import me.lucko.helper.mongo.external.bson.FieldNameValidator;
import me.lucko.helper.mongo.external.bson.codecs.EncoderContext;
import me.lucko.helper.mongo.external.bson.io.BsonOutput;
import me.lucko.helper.mongo.external.mongodriver.MongoNamespace;
import me.lucko.helper.mongo.external.mongodriver.WriteConcern;
import me.lucko.helper.mongo.external.mongodriver.bulk.DeleteRequest;
import me.lucko.helper.mongo.external.mongodriver.connection.BaseWriteCommandMessage;
import me.lucko.helper.mongo.external.mongodriver.connection.MessageSettings;
import me.lucko.helper.mongo.external.mongodriver.internal.validator.NoOpFieldNameValidator;

class DeleteCommandMessage
extends BaseWriteCommandMessage {
    private final List<DeleteRequest> deletes;

    DeleteCommandMessage(MongoNamespace namespace, boolean ordered, WriteConcern writeConcern, MessageSettings settings, List<DeleteRequest> deletes) {
        super(namespace, ordered, writeConcern, null, settings);
        this.deletes = deletes;
    }

    @Override
    public int getItemCount() {
        return this.deletes.size();
    }

    @Override
    protected FieldNameValidator getFieldNameValidator() {
        return new NoOpFieldNameValidator();
    }

    public List<DeleteRequest> getRequests() {
        return Collections.unmodifiableList(this.deletes);
    }

    @Override
    protected String getCommandName() {
        return "delete";
    }

    @Override
    protected BaseWriteCommandMessage writeTheWrites(BsonOutput bsonOutput, int commandStartPosition, BsonBinaryWriter writer) {
        DeleteCommandMessage nextMessage = null;
        writer.writeStartArray("deletes");
        for (int i = 0; i < this.deletes.size(); ++i) {
            writer.mark();
            DeleteRequest deleteRequest = this.deletes.get(i);
            writer.writeStartDocument();
            writer.pushMaxDocumentSize(this.getSettings().getMaxDocumentSize());
            writer.writeName("q");
            this.getCodec(deleteRequest.getFilter()).encode(writer, deleteRequest.getFilter(), EncoderContext.builder().build());
            writer.writeInt32("limit", deleteRequest.isMulti() ? 0 : 1);
            if (deleteRequest.getCollation() != null) {
                writer.writeName("collation");
                BsonDocument collation = deleteRequest.getCollation().asDocument();
                this.getCodec(collation).encode(writer, collation, EncoderContext.builder().build());
            }
            writer.popMaxDocumentSize();
            writer.writeEndDocument();
            if (!this.exceedsLimits(bsonOutput.getPosition() - commandStartPosition, i + 1)) continue;
            writer.reset();
            nextMessage = new DeleteCommandMessage(this.getWriteNamespace(), this.isOrdered(), this.getWriteConcern(), this.getSettings(), this.deletes.subList(i, this.deletes.size()));
            break;
        }
        writer.writeEndArray();
        return nextMessage;
    }
}

