/*
 * Decompiled with CFR 0.152.
 */
package me.lucko.helper.mongo.external.mongodriver.connection;

import me.lucko.helper.mongo.external.mongodriver.MongoException;
import me.lucko.helper.mongo.external.mongodriver.MongoNodeIsRecoveringException;
import me.lucko.helper.mongo.external.mongodriver.MongoNotPrimaryException;
import me.lucko.helper.mongo.external.mongodriver.MongoSecurityException;
import me.lucko.helper.mongo.external.mongodriver.MongoSocketException;
import me.lucko.helper.mongo.external.mongodriver.MongoSocketReadTimeoutException;
import me.lucko.helper.mongo.external.mongodriver.assertions.Assertions;
import me.lucko.helper.mongo.external.mongodriver.async.SingleResultCallback;
import me.lucko.helper.mongo.external.mongodriver.connection.AsyncConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.ChangeEvent;
import me.lucko.helper.mongo.external.mongodriver.connection.ChangeListener;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterConnectionMode;
import me.lucko.helper.mongo.external.mongodriver.connection.ClusterableServer;
import me.lucko.helper.mongo.external.mongodriver.connection.Connection;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionFactory;
import me.lucko.helper.mongo.external.mongodriver.connection.ConnectionPool;
import me.lucko.helper.mongo.external.mongodriver.connection.InternalConnection;
import me.lucko.helper.mongo.external.mongodriver.connection.Protocol;
import me.lucko.helper.mongo.external.mongodriver.connection.ProtocolExecutor;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerConnectionState;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerDescription;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerId;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerMonitor;
import me.lucko.helper.mongo.external.mongodriver.connection.ServerMonitorFactory;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Logger;
import me.lucko.helper.mongo.external.mongodriver.diagnostics.logging.Loggers;
import me.lucko.helper.mongo.external.mongodriver.event.CommandListener;
import me.lucko.helper.mongo.external.mongodriver.event.ServerClosedEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ServerDescriptionChangedEvent;
import me.lucko.helper.mongo.external.mongodriver.event.ServerListener;
import me.lucko.helper.mongo.external.mongodriver.event.ServerOpeningEvent;
import me.lucko.helper.mongo.external.mongodriver.internal.async.ErrorHandlingResultCallback;

class DefaultServer
implements ClusterableServer {
    private static final Logger LOGGER = Loggers.getLogger("connection");
    private final ServerId serverId;
    private final ConnectionPool connectionPool;
    private final ClusterConnectionMode clusterConnectionMode;
    private final ConnectionFactory connectionFactory;
    private final ServerMonitor serverMonitor;
    private final ChangeListener<ServerDescription> serverStateListener;
    private final ServerListener serverListener;
    private final CommandListener commandListener;
    private volatile ServerDescription description;
    private volatile boolean isClosed;

    DefaultServer(ServerId serverId, ClusterConnectionMode clusterConnectionMode, ConnectionPool connectionPool, ConnectionFactory connectionFactory, ServerMonitorFactory serverMonitorFactory, ServerListener serverListener, CommandListener commandListener) {
        this.serverListener = Assertions.notNull("serverListener", serverListener);
        this.commandListener = commandListener;
        Assertions.notNull("serverAddress", serverId);
        Assertions.notNull("serverMonitorFactory", serverMonitorFactory);
        this.clusterConnectionMode = Assertions.notNull("clusterConnectionMode", clusterConnectionMode);
        this.connectionFactory = Assertions.notNull("connectionFactory", connectionFactory);
        this.connectionPool = Assertions.notNull("connectionPool", connectionPool);
        this.serverStateListener = new DefaultServerStateListener();
        this.serverId = serverId;
        serverListener.serverOpening(new ServerOpeningEvent(this.serverId));
        this.description = ServerDescription.builder().state(ServerConnectionState.CONNECTING).address(serverId.getAddress()).build();
        this.serverMonitor = serverMonitorFactory.create(this.serverStateListener);
        this.serverMonitor.start();
    }

    @Override
    public Connection getConnection() {
        Assertions.isTrue("open", !this.isClosed());
        try {
            return this.connectionFactory.create(this.connectionPool.get(), new DefaultServerProtocolExecutor(), this.clusterConnectionMode);
        }
        catch (MongoSecurityException e) {
            this.invalidate();
            throw e;
        }
    }

    @Override
    public void getConnectionAsync(final SingleResultCallback<AsyncConnection> callback) {
        Assertions.isTrue("open", !this.isClosed());
        this.connectionPool.getAsync(new SingleResultCallback<InternalConnection>(){

            @Override
            public void onResult(InternalConnection result, Throwable t) {
                if (t instanceof MongoSecurityException) {
                    DefaultServer.this.invalidate();
                }
                if (t != null) {
                    callback.onResult(null, t);
                } else {
                    callback.onResult(DefaultServer.this.connectionFactory.createAsync(result, new DefaultServerProtocolExecutor(), DefaultServer.this.clusterConnectionMode), null);
                }
            }
        });
    }

    @Override
    public ServerDescription getDescription() {
        Assertions.isTrue("open", !this.isClosed());
        return this.description;
    }

    @Override
    public void invalidate() {
        Assertions.isTrue("open", !this.isClosed());
        this.serverStateListener.stateChanged(new ChangeEvent<ServerDescription>(this.description, ServerDescription.builder().state(ServerConnectionState.CONNECTING).address(this.serverId.getAddress()).build()));
        this.connectionPool.invalidate();
        this.connect();
    }

    @Override
    public void close() {
        if (!this.isClosed()) {
            this.connectionPool.close();
            this.serverMonitor.close();
            this.isClosed = true;
            this.serverListener.serverClosed(new ServerClosedEvent(this.serverId));
        }
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void connect() {
        this.serverMonitor.connect();
    }

    ConnectionPool getConnectionPool() {
        return this.connectionPool;
    }

    private void handleThrowable(Throwable t) {
        if (t instanceof MongoSocketException && !(t instanceof MongoSocketReadTimeoutException) || t instanceof MongoNotPrimaryException || t instanceof MongoNodeIsRecoveringException) {
            this.invalidate();
        }
    }

    private final class DefaultServerStateListener
    implements ChangeListener<ServerDescription> {
        private DefaultServerStateListener() {
        }

        @Override
        public void stateChanged(ChangeEvent<ServerDescription> event) {
            ServerDescription oldDescription = DefaultServer.this.description;
            DefaultServer.this.description = event.getNewValue();
            DefaultServer.this.serverListener.serverDescriptionChanged(new ServerDescriptionChangedEvent(DefaultServer.this.serverId, DefaultServer.this.description, oldDescription));
        }
    }

    private class DefaultServerProtocolExecutor
    implements ProtocolExecutor {
        private DefaultServerProtocolExecutor() {
        }

        @Override
        public <T> T execute(Protocol<T> protocol, InternalConnection connection) {
            try {
                protocol.setCommandListener(DefaultServer.this.commandListener);
                return protocol.execute(connection);
            }
            catch (MongoException e) {
                DefaultServer.this.handleThrowable(e);
                throw e;
            }
        }

        @Override
        public <T> void executeAsync(Protocol<T> protocol, InternalConnection connection, final SingleResultCallback<T> callback) {
            protocol.setCommandListener(DefaultServer.this.commandListener);
            protocol.executeAsync(connection, ErrorHandlingResultCallback.errorHandlingCallback(new SingleResultCallback<T>(){

                @Override
                public void onResult(T result, Throwable t) {
                    if (t != null) {
                        DefaultServer.this.handleThrowable(t);
                    }
                    callback.onResult(result, t);
                }
            }, LOGGER));
        }
    }
}

